/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.util.Assert;

public class JacksonMongoSessionConverter
extends AbstractMongoSessionConverter {
    private static final Log LOG = LogFactory.getLog(JacksonMongoSessionConverter.class);
    private static final String ATTRS_FIELD_NAME = "attrs.";
    private static final String PRINCIPAL_FIELD_NAME = "principal";
    private static final String EXPIRE_AT_FIELD_NAME = "expireAt";
    private final ObjectMapper objectMapper;

    public JacksonMongoSessionConverter() {
        this(Collections.emptyList());
    }

    public JacksonMongoSessionConverter(Iterable<Module> modules) {
        this.objectMapper = this.buildObjectMapper();
        this.objectMapper.registerModules(modules);
    }

    public JacksonMongoSessionConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper can NOT be null!");
        this.objectMapper = objectMapper;
    }

    @Override
    @Nullable
    protected Query getQueryForIndex(String indexName, Object indexValue) {
        if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Query.query((CriteriaDefinition)Criteria.where((String)PRINCIPAL_FIELD_NAME).is(indexValue));
        }
        return Query.query((CriteriaDefinition)Criteria.where((String)(ATTRS_FIELD_NAME + MongoSession.coverDot(indexName))).is(indexValue));
    }

    private ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new MongoIdNamingStrategy());
        objectMapper.registerModules((Iterable)SecurityJackson2Modules.getModules((ClassLoader)this.getClass().getClassLoader()));
        objectMapper.addMixIn(MongoSession.class, MongoSessionMixin.class);
        objectMapper.addMixIn(HashMap.class, HashMapMixin.class);
        return objectMapper;
    }

    @Override
    protected DBObject convert(MongoSession source) {
        try {
            BasicDBObject dbSession = BasicDBObject.parse((String)this.objectMapper.writeValueAsString((Object)source));
            dbSession.put(PRINCIPAL_FIELD_NAME, (Object)this.extractPrincipal(source));
            dbSession.put(EXPIRE_AT_FIELD_NAME, (Object)source.getExpireAt());
            return dbSession;
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Cannot convert MongoExpiringSession", ex);
        }
    }

    @Override
    @Nullable
    protected MongoSession convert(Document source) {
        Date expireAt = (Date)source.remove((Object)EXPIRE_AT_FIELD_NAME);
        source.remove((Object)"originalSessionId");
        String json = source.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
        try {
            MongoSession mongoSession = (MongoSession)this.objectMapper.readValue(json, MongoSession.class);
            mongoSession.setExpireAt(expireAt);
            return mongoSession;
        }
        catch (IOException ex) {
            LOG.error((Object)"Error during Mongo Session deserialization", (Throwable)ex);
            return null;
        }
    }

    private static class MongoIdNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private MongoIdNamingStrategy() {
        }

        public String translate(String propertyName) {
            switch (propertyName) {
                case "id": {
                    return "_id";
                }
                case "_id": {
                    return "id";
                }
            }
            return propertyName;
        }
    }

    private static class MongoSessionMixin {
        @JsonCreator
        MongoSessionMixin(@JsonProperty(value="_id") String id, @JsonProperty(value="intervalSeconds") long maxInactiveIntervalInSeconds) {
        }
    }

    private static class HashMapMixin {
        private HashMapMixin() {
        }
    }
}

