/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.server;

import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.config.annotation.web.server.SpringWebSessionConfiguration;
import org.springframework.session.data.redis.ReactiveRedisOperationsSessionRepository;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;
import org.springframework.session.data.redis.config.annotation.web.server.EnableRedisWebSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration
public class RedisWebSessionConfiguration
extends SpringWebSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware {
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String redisNamespace = "spring:session";
    private RedisFlushMode redisFlushMode = RedisFlushMode.ON_SAVE;
    private ReactiveRedisConnectionFactory redisConnectionFactory;
    private ClassLoader classLoader;
    private StringValueResolver embeddedValueResolver;

    @Bean
    public ReactiveRedisOperationsSessionRepository sessionRepository() {
        ReactiveRedisTemplate<String, Object> reactiveRedisTemplate = this.createReactiveRedisTemplate();
        ReactiveRedisOperationsSessionRepository sessionRepository = new ReactiveRedisOperationsSessionRepository((ReactiveRedisOperations<String, Object>)reactiveRedisTemplate);
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        if (StringUtils.hasText((String)this.redisNamespace)) {
            sessionRepository.setRedisKeyNamespace(this.redisNamespace);
        }
        sessionRepository.setRedisFlushMode(this.redisFlushMode);
        return sessionRepository;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setRedisNamespace(String namespace) {
        this.redisNamespace = namespace;
    }

    public void setRedisFlushMode(RedisFlushMode redisFlushMode) {
        Assert.notNull((Object)((Object)redisFlushMode), (String)"redisFlushMode cannot be null");
        this.redisFlushMode = redisFlushMode;
    }

    @Autowired
    public void setRedisConnectionFactory(@SpringSessionRedisConnectionFactory ObjectProvider<ReactiveRedisConnectionFactory> springSessionRedisConnectionFactory, ObjectProvider<ReactiveRedisConnectionFactory> redisConnectionFactory) {
        ReactiveRedisConnectionFactory redisConnectionFactoryToUse = (ReactiveRedisConnectionFactory)springSessionRedisConnectionFactory.getIfAvailable();
        if (redisConnectionFactoryToUse == null) {
            redisConnectionFactoryToUse = (ReactiveRedisConnectionFactory)redisConnectionFactory.getObject();
        }
        this.redisConnectionFactory = redisConnectionFactoryToUse;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableRedisWebSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
        String redisNamespaceValue = attributes.getString("redisNamespace");
        if (StringUtils.hasText((String)redisNamespaceValue)) {
            this.redisNamespace = this.embeddedValueResolver.resolveStringValue(redisNamespaceValue);
        }
        this.redisFlushMode = (RedisFlushMode)attributes.getEnum("redisFlushMode");
    }

    private ReactiveRedisTemplate<String, Object> createReactiveRedisTemplate() {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer valueSerializer = new JdkSerializationRedisSerializer(this.classLoader);
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext((RedisSerializer)valueSerializer).key((RedisSerializer)keySerializer).hashKey((RedisSerializer)keySerializer).build();
        return new ReactiveRedisTemplate(this.redisConnectionFactory, serializationContext);
    }
}

