/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.http;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.FlushMode;
import org.springframework.session.MapSession;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={SpringHttpSessionConfiguration.class})
public abstract class AbstractRedisHttpSessionConfiguration<T extends SessionRepository<? extends Session>>
implements BeanClassLoaderAware {
    private Duration maxInactiveInterval = MapSession.DEFAULT_MAX_INACTIVE_INTERVAL;
    private String redisNamespace = "spring:session";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private RedisConnectionFactory redisConnectionFactory;
    private RedisSerializer<Object> defaultRedisSerializer;
    private List<SessionRepositoryCustomizer<T>> sessionRepositoryCustomizers;
    private ClassLoader classLoader;

    public abstract T sessionRepository();

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Deprecated
    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds));
    }

    protected Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setRedisNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace must not be empty");
        this.redisNamespace = namespace;
    }

    protected String getRedisNamespace() {
        return this.redisNamespace;
    }

    public void setFlushMode(FlushMode flushMode) {
        Assert.notNull((Object)flushMode, (String)"flushMode must not be null");
        this.flushMode = flushMode;
    }

    protected FlushMode getFlushMode() {
        return this.flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    protected SaveMode getSaveMode() {
        return this.saveMode;
    }

    @Autowired
    public void setRedisConnectionFactory(@SpringSessionRedisConnectionFactory ObjectProvider<RedisConnectionFactory> springSessionRedisConnectionFactory, ObjectProvider<RedisConnectionFactory> redisConnectionFactory) {
        this.redisConnectionFactory = (RedisConnectionFactory)springSessionRedisConnectionFactory.getIfAvailable(() -> redisConnectionFactory.getObject());
    }

    protected RedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionDefaultRedisSerializer")
    public void setDefaultRedisSerializer(RedisSerializer<Object> defaultRedisSerializer) {
        this.defaultRedisSerializer = defaultRedisSerializer;
    }

    protected RedisSerializer<Object> getDefaultRedisSerializer() {
        return this.defaultRedisSerializer;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<T>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    protected List<SessionRepositoryCustomizer<T>> getSessionRepositoryCustomizers() {
        return this.sessionRepositoryCustomizers;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected RedisTemplate<String, Object> createRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        if (this.getDefaultRedisSerializer() != null) {
            redisTemplate.setDefaultSerializer(this.getDefaultRedisSerializer());
        }
        redisTemplate.setConnectionFactory(this.getRedisConnectionFactory());
        redisTemplate.setBeanClassLoader(this.classLoader);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

