/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast.config.annotation.web.http;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Map;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.MapSession;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.hazelcast.HazelcastFlushMode;
import org.springframework.session.hazelcast.HazelcastSessionRepository;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;

@Configuration
public class HazelcastHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    static final String DEFAULT_SESSION_MAP_NAME = "spring:session:sessions";
    private Integer maxInactiveIntervalInSeconds;
    private String sessionMapName = "spring:session:sessions";
    private HazelcastFlushMode hazelcastFlushMode = HazelcastFlushMode.ON_SAVE;

    @Bean
    public HazelcastSessionRepository sessionRepository(HazelcastInstance hazelcastInstance, ApplicationEventPublisher eventPublisher) {
        IMap sessions = hazelcastInstance.getMap(this.sessionMapName);
        HazelcastSessionRepository sessionRepository = new HazelcastSessionRepository((IMap<String, MapSession>)sessions);
        sessionRepository.setApplicationEventPublisher(eventPublisher);
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        sessionRepository.setHazelcastFlushMode(this.hazelcastFlushMode);
        return sessionRepository;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableHazelcastHttpSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        this.setMaxInactiveIntervalInSeconds((Integer)enableAttrs.getNumber("maxInactiveIntervalInSeconds"));
        this.setSessionMapName(enableAttrs.getString("sessionMapName"));
        this.setHazelcastFlushMode((HazelcastFlushMode)enableAttrs.getEnum("hazelcastFlushMode"));
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    public void setHazelcastFlushMode(HazelcastFlushMode hazelcastFlushMode) {
        this.hazelcastFlushMode = hazelcastFlushMode;
    }
}

