/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.util.List;
import java.util.stream.Collectors;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.shell.CompletingParsedLine;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.Shell;

@Configuration(proxyBeanMethods=false)
public class CompleterAutoConfiguration {
    @Autowired
    private Shell shell;

    @Bean
    public CompleterAdapter completer() {
        CompleterAdapter completerAdapter = new CompleterAdapter();
        completerAdapter.setShell(this.shell);
        return completerAdapter;
    }

    public static class CompleterAdapter
    implements Completer {
        private Shell shell;

        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            CompletingParsedLine cpl = line instanceof CompletingParsedLine ? (CompletingParsedLine)line : t -> t;
            CompletionContext context = new CompletionContext(CompleterAdapter.sanitizeInput(line.words()), line.wordIndex(), line.wordCursor(), null, null);
            List proposals = this.shell.complete(context);
            proposals.stream().map(p -> new Candidate(p.dontQuote() ? p.value() : cpl.emit((CharSequence)p.value()).toString(), p.displayText(), p.category(), p.description(), null, null, true)).forEach(candidates::add);
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }

        static List<String> sanitizeInput(List<String> words) {
            words = words.stream().map(s -> s.replaceAll("^\\n+|\\n+$", "")).map(s -> s.replaceAll("\\n+", " ")).collect(Collectors.toList());
            return words;
        }
    }
}

