/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.MethodTargetRegistrar;
import org.springframework.shell.boot.CommandRegistrationCustomizer;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.command.CommandCatalogCustomizer;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.CommandResolver;
import org.springframework.shell.command.support.OptionNameModifierSupport;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class CommandCatalogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CommandCatalog.class})
    public CommandCatalog commandCatalog(ObjectProvider<MethodTargetRegistrar> methodTargetRegistrars, ObjectProvider<CommandResolver> commandResolvers, ObjectProvider<CommandCatalogCustomizer> commandCatalogCustomizers) {
        List resolvers = commandResolvers.orderedStream().collect(Collectors.toList());
        CommandCatalog catalog = CommandCatalog.of(resolvers, null);
        methodTargetRegistrars.orderedStream().forEach(resolver -> resolver.register(catalog));
        commandCatalogCustomizers.orderedStream().forEach(customizer -> customizer.customize(catalog));
        return catalog;
    }

    @Bean
    public CommandCatalogCustomizer defaultCommandCatalogCustomizer(ObjectProvider<CommandRegistration> commandRegistrations) {
        return catalog -> commandRegistrations.orderedStream().forEach(registration -> catalog.register(new CommandRegistration[]{registration}));
    }

    @Bean
    public CommandRegistrationCustomizer helpOptionsCommandRegistrationCustomizer(SpringShellProperties properties) {
        return registration -> {
            SpringShellProperties.Help help = properties.getHelp();
            if (help.isEnabled()) {
                registration.withHelpOptions().enabled(true).longNames(help.getLongNames()).shortNames(help.getShortNames()).command(help.getCommand());
            }
        };
    }

    @Bean
    @ConditionalOnBean(value={CommandRegistration.OptionNameModifier.class})
    public CommandRegistrationCustomizer customOptionNameModifierCommandRegistrationCustomizer(CommandRegistration.OptionNameModifier modifier) {
        return builder -> builder.defaultOptionNameModifier((Function)modifier);
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandRegistration.OptionNameModifier.class})
    @ConditionalOnProperty(prefix="spring.shell.option.naming", name={"case-type"})
    public CommandRegistrationCustomizer defaultOptionNameModifierCommandRegistrationCustomizer(SpringShellProperties properties) {
        return builder -> {
            switch (properties.getOption().getNaming().getCaseType()) {
                case NOOP: {
                    break;
                }
                case CAMEL: {
                    builder.defaultOptionNameModifier((Function)OptionNameModifierSupport.CAMELCASE);
                    break;
                }
                case SNAKE: {
                    builder.defaultOptionNameModifier((Function)OptionNameModifierSupport.SNAKECASE);
                    break;
                }
                case KEBAB: {
                    builder.defaultOptionNameModifier((Function)OptionNameModifierSupport.KEBABCASE);
                    break;
                }
                case PASCAL: {
                    builder.defaultOptionNameModifier((Function)OptionNameModifierSupport.PASCALCASE);
                    break;
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandRegistration.BuilderSupplier commandRegistrationBuilderSupplier(ObjectProvider<CommandRegistrationCustomizer> customizerProvider) {
        return () -> {
            CommandRegistration.Builder builder = CommandRegistration.builder();
            customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        };
    }
}

