/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.Shell;
import org.springframework.shell.boot.NonInteractiveShellRunnerCustomizer;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.InteractiveShellRunner;
import org.springframework.shell.jline.NonInteractiveShellRunner;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.shell.jline.ScriptShellRunner;

@AutoConfiguration
public class ShellRunnerAutoConfiguration {
    private Shell shell;
    private PromptProvider promptProvider;
    private LineReader lineReader;
    private Parser parser;
    private ShellContext shellContext;

    public ShellRunnerAutoConfiguration(Shell shell, PromptProvider promptProvider, LineReader lineReader, Parser parser, ShellContext shellContext) {
        this.shell = shell;
        this.promptProvider = promptProvider;
        this.lineReader = lineReader;
        this.parser = parser;
        this.shellContext = shellContext;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.shell.interactive", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public InteractiveShellRunner interactiveApplicationRunner() {
        return new InteractiveShellRunner(this.lineReader, this.promptProvider, this.shell, this.shellContext);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.shell.noninteractive", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public NonInteractiveShellRunner nonInteractiveApplicationRunner(ObjectProvider<NonInteractiveShellRunnerCustomizer> customizer) {
        NonInteractiveShellRunner shellRunner = new NonInteractiveShellRunner(this.shell, this.shellContext);
        customizer.orderedStream().forEach(c -> c.customize(shellRunner));
        return shellRunner;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.shell.script", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public ScriptShellRunner scriptApplicationRunner() {
        return new ScriptShellRunner(this.parser, this.shell);
    }
}

