/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.util.Set;
import org.jline.terminal.Terminal;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.shell.ResultHandler;
import org.springframework.shell.ResultHandlerService;
import org.springframework.shell.Shell;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.config.ShellConversionServiceSupplier;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.exit.ExitCodeMappings;
import org.springframework.shell.result.GenericResultHandlerService;
import org.springframework.shell.result.ResultHandlerConfig;

@AutoConfiguration
@Import(value={ResultHandlerConfig.class})
public class SpringShellAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ShellConversionServiceSupplier shellConversionServiceSupplier(ApplicationContext applicationContext) {
        FormattingConversionService service = new FormattingConversionService();
        DefaultConversionService.addDefaultConverters((ConverterRegistry)service);
        DefaultConversionService.addCollectionConverters((ConverterRegistry)service);
        ApplicationConversionService.addBeans((FormatterRegistry)service, (ListableBeanFactory)applicationContext);
        return () -> service;
    }

    @Bean
    public ResultHandlerService resultHandlerService(Set<ResultHandler<?>> resultHandlers) {
        GenericResultHandlerService service = new GenericResultHandlerService();
        for (ResultHandler<?> resultHandler : resultHandlers) {
            service.addResultHandler(resultHandler);
        }
        return service;
    }

    @Bean
    public Shell shell(ResultHandlerService resultHandlerService, CommandCatalog commandRegistry, Terminal terminal, ShellConversionServiceSupplier shellConversionServiceSupplier, ShellContext shellContext, ExitCodeMappings exitCodeMappings) {
        Shell shell = new Shell(resultHandlerService, commandRegistry, terminal, shellContext, exitCodeMappings);
        shell.setConversionService((ConversionService)shellConversionServiceSupplier.get());
        return shell;
    }
}

