/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.jline.reader.Parser;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.boot.condition.OnCompletionCommandCondition;
import org.springframework.shell.result.ThrowableResultHandler;
import org.springframework.shell.standard.commands.Clear;
import org.springframework.shell.standard.commands.Completion;
import org.springframework.shell.standard.commands.Help;
import org.springframework.shell.standard.commands.History;
import org.springframework.shell.standard.commands.Quit;
import org.springframework.shell.standard.commands.Script;
import org.springframework.shell.standard.commands.Stacktrace;
import org.springframework.shell.standard.commands.Version;
import org.springframework.shell.style.TemplateExecutor;

@AutoConfiguration
@ConditionalOnClass(value={Help.Command.class})
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class StandardCommandsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Help.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.help", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public Help help(SpringShellProperties properties, ObjectProvider<TemplateExecutor> templateExecutor) {
        Help help = new Help((TemplateExecutor)templateExecutor.getIfAvailable());
        if (properties.getCommand().getHelp().getGroupingMode() == SpringShellProperties.HelpCommand.GroupingMode.FLAT) {
            help.setShowGroups(false);
        }
        help.setCommandTemplate(properties.getCommand().getHelp().getCommandTemplate());
        help.setCommandsTemplate(properties.getCommand().getHelp().getCommandsTemplate());
        return help;
    }

    @Bean
    @ConditionalOnMissingBean(value={Clear.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.clear", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public Clear clear() {
        return new Clear();
    }

    @Bean
    @ConditionalOnMissingBean(value={Quit.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.quit", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public Quit quit() {
        return new Quit();
    }

    @Bean
    @ConditionalOnMissingBean(value={Stacktrace.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.stacktrace", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public Stacktrace stacktrace(ObjectProvider<ThrowableResultHandler> throwableResultHandler) {
        return new Stacktrace(throwableResultHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={Script.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.script", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public Script script(Parser parser) {
        return new Script(parser);
    }

    @Bean
    @ConditionalOnMissingBean(value={History.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.history", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public History historyCommand(org.jline.reader.History jLineHistory) {
        return new History(jLineHistory);
    }

    @Bean
    @ConditionalOnMissingBean(value={Completion.Command.class})
    @Conditional(value={OnCompletionCommandCondition.class})
    public Completion completion(SpringShellProperties properties) {
        return new Completion(properties.getCommand().getCompletion().getRootCommand());
    }

    @Bean
    @ConditionalOnMissingBean(value={Version.Command.class})
    @ConditionalOnProperty(prefix="spring.shell.command.version", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public Version version(SpringShellProperties properties, ObjectProvider<BuildProperties> buildProperties, ObjectProvider<GitProperties> gitProperties, ObjectProvider<TemplateExecutor> templateExecutor) {
        Version version = new Version((TemplateExecutor)templateExecutor.getIfAvailable());
        version.setBuildProperties((BuildProperties)buildProperties.getIfAvailable());
        version.setGitProperties((GitProperties)gitProperties.getIfAvailable());
        SpringShellProperties.VersionCommand versionProperties = properties.getCommand().getVersion();
        version.setTemplate(versionProperties.getTemplate());
        version.setShowBuildArtifact(versionProperties.isShowBuildArtifact());
        version.setShowBuildGroup(versionProperties.isShowBuildGroup());
        version.setShowBuildName(versionProperties.isShowBuildName());
        version.setShowBuildTime(versionProperties.isShowBuildTime());
        version.setShowBuildVersion(versionProperties.isShowBuildVersion());
        version.setShowGitBranch(versionProperties.isShowGitBranch());
        version.setShowGitCommitId(versionProperties.isShowGitCommitId());
        version.setShowGitShortCommitId(versionProperties.isShowGitShortCommitId());
        version.setShowGitCommitTime(versionProperties.isShowGitCommitTime());
        return version;
    }
}

