/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.shell.Availability;
import org.springframework.shell.command.CommandOption;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.standard.commands.CommandAvailabilityInfoModel;
import org.springframework.shell.standard.commands.CommandParameterInfoModel;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class CommandInfoModel {
    private String name;
    private List<String> aliases;
    private String description;
    private List<CommandParameterInfoModel> parameters;
    private CommandAvailabilityInfoModel availability;

    CommandInfoModel(String name, List<String> aliases, String description, List<CommandParameterInfoModel> parameters, CommandAvailabilityInfoModel availability) {
        this.name = name;
        this.aliases = aliases;
        this.description = description;
        this.parameters = parameters;
        this.availability = availability;
    }

    static CommandInfoModel of(String name, CommandRegistration registration) {
        List options = registration.getOptions();
        List<CommandParameterInfoModel> parameters = options.stream().map(o -> {
            String type = CommandInfoModel.commandOptionType(o);
            List<String> arguments = Stream.concat(Stream.of(o.getLongNames()).map(a -> "--" + a), Stream.of(o.getShortNames()).map(s -> "-" + s)).collect(Collectors.toList());
            boolean required = o.isRequired();
            String description = o.getDescription();
            String defaultValue = o.getDefaultValue();
            return CommandParameterInfoModel.of(type, arguments, required, description, defaultValue);
        }).collect(Collectors.toList());
        List<String> aliases = registration.getAliases().stream().map(ca -> ca.getCommand()).collect(Collectors.toList());
        String description = registration.getDescription();
        boolean available = true;
        String availReason = "";
        if (registration.getAvailability() != null) {
            Availability a = registration.getAvailability();
            available = a.isAvailable();
            availReason = a.getReason();
        }
        CommandAvailabilityInfoModel availModel = CommandAvailabilityInfoModel.of(available, availReason);
        return new CommandInfoModel(name, aliases, description, parameters, availModel);
    }

    private static String commandOptionType(CommandOption o) {
        if (StringUtils.hasText((String)o.getLabel())) {
            return o.getLabel();
        }
        if (o.getType() != null) {
            if (ClassUtils.isAssignable((Class)o.getType().getRawClass(), Void.class)) {
                return "";
            }
            return ClassUtils.getShortName((Class)o.getType().getRawClass());
        }
        return "String";
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNames() {
        return Arrays.asList(this.name.split(" "));
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CommandParameterInfoModel> getParameters() {
        return this.parameters;
    }

    public CommandAvailabilityInfoModel getAvailability() {
        return this.availability;
    }
}

