/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.util.stream.Stream;
import org.jline.terminal.Terminal;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.shell.Shell;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.completion.CompletionResolver;
import org.springframework.shell.component.ViewComponentBuilder;
import org.springframework.shell.style.TemplateExecutor;
import org.springframework.shell.style.ThemeResolver;

public abstract class AbstractShellComponent
implements ApplicationContextAware,
InitializingBean,
ResourceLoaderAware {
    private ApplicationContext applicationContext;
    private ResourceLoader resourceLoader;
    private ObjectProvider<Shell> shellProvider;
    private ObjectProvider<Terminal> terminalProvider;
    private ObjectProvider<CommandCatalog> commandCatalogProvider;
    private ObjectProvider<CompletionResolver> completionResolverProvider;
    private ObjectProvider<TemplateExecutor> templateExecutorProvider;
    private ObjectProvider<ThemeResolver> themeResolverProvider;
    private ObjectProvider<ViewComponentBuilder> viewComponentBuilderProvider;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.shellProvider = this.applicationContext.getBeanProvider(Shell.class);
        this.terminalProvider = this.applicationContext.getBeanProvider(Terminal.class);
        this.commandCatalogProvider = this.applicationContext.getBeanProvider(CommandCatalog.class);
        this.completionResolverProvider = this.applicationContext.getBeanProvider(CompletionResolver.class);
        this.templateExecutorProvider = this.applicationContext.getBeanProvider(TemplateExecutor.class);
        this.themeResolverProvider = this.applicationContext.getBeanProvider(ThemeResolver.class);
        this.viewComponentBuilderProvider = this.applicationContext.getBeanProvider(ViewComponentBuilder.class);
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    protected Shell getShell() {
        return (Shell)this.shellProvider.getObject();
    }

    protected Terminal getTerminal() {
        return (Terminal)this.terminalProvider.getObject();
    }

    protected CommandCatalog getCommandCatalog() {
        return (CommandCatalog)this.commandCatalogProvider.getObject();
    }

    protected Stream<CompletionResolver> getCompletionResolver() {
        return this.completionResolverProvider.orderedStream();
    }

    protected TemplateExecutor getTemplateExecutor() {
        return (TemplateExecutor)this.templateExecutorProvider.getObject();
    }

    protected ThemeResolver getThemeResolver() {
        return (ThemeResolver)this.themeResolverProvider.getObject();
    }

    protected ViewComponentBuilder getViewComponentBuilder() {
        return (ViewComponentBuilder)this.viewComponentBuilderProvider.getObject();
    }
}

