/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.shell.Shell;
import org.springframework.shell.ShellRunner;
import org.springframework.shell.context.DefaultShellContext;
import org.springframework.shell.context.ShellContext;
import org.springframework.shell.jline.InteractiveShellRunner;
import org.springframework.shell.jline.NonInteractiveShellRunner;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.shell.test.ShellScreen;
import org.springframework.shell.test.ShellWriteSequence;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalSession;

public interface ShellTestClient
extends Closeable {
    public InteractiveShellSession interactive();

    public NonInteractiveShellSession nonInterative(String ... var1);

    public ShellScreen screen();

    public static Builder builder(TerminalSession terminalSession, Shell shell, PromptProvider promptProvider, LineReader lineReader, Terminal terminal) {
        return new DefaultBuilder(terminalSession, shell, promptProvider, lineReader, terminal);
    }

    public static class DefaultBuilder
    implements Builder {
        private TerminalSession terminalSession;
        private Shell shell;
        private PromptProvider promptProvider;
        private LineReader lineReader;
        private Terminal terminal;

        DefaultBuilder(TerminalSession terminalSession, Shell shell, PromptProvider promptProvider, LineReader lineReader, Terminal terminal) {
            this.terminalSession = terminalSession;
            this.shell = shell;
            this.promptProvider = promptProvider;
            this.lineReader = lineReader;
            this.terminal = terminal;
        }

        @Override
        public ShellTestClient build() {
            return new DefaultShellClient(this.terminalSession, this.shell, this.promptProvider, this.lineReader, this.terminal);
        }
    }

    public static class ShellRunnerTask
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(ShellRunnerTask.class);
        private BlockingQueue<ShellRunnerTaskData> blockingQueue;

        ShellRunnerTask(BlockingQueue<ShellRunnerTaskData> blockingQueue) {
            this.blockingQueue = blockingQueue;
        }

        @Override
        public void run() {
            log.trace("ShellRunnerTask start");
            try {
                Thread.currentThread().setName("ShellRunnerTask");
                while (true) {
                    ShellRunnerTaskData data = this.blockingQueue.take();
                    if (data.runner == null) {
                        return;
                    }
                    try {
                        log.trace("Running {}", (Object)data.runner());
                        data.state().set(-1);
                        data.runner().run(data.args());
                        data.state().set(0);
                        log.trace("Running done {}", (Object)data.runner());
                    }
                    catch (Exception e) {
                        data.state().set(1);
                        log.trace("ShellRunnerThread ex", (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.trace("ShellRunnerTask end");
                return;
            }
        }
    }

    public record ShellRunnerTaskData(ShellRunner runner, ApplicationArguments args, AtomicInteger state) {
    }

    public static class DefaultNonInteractiveShellSession
    implements NonInteractiveShellSession {
        private Shell shell;
        private String[] args;
        private BlockingQueue<ShellRunnerTaskData> blockingQueue;
        private TerminalSession terminalSession;
        private Terminal terminal;
        private final AtomicInteger state = new AtomicInteger(-2);

        public DefaultNonInteractiveShellSession(Shell shell, String[] args, BlockingQueue<ShellRunnerTaskData> blockingQueue, TerminalSession terminalSession, Terminal terminal) {
            this.shell = shell;
            this.args = args;
            this.blockingQueue = blockingQueue;
            this.terminalSession = terminalSession;
            this.terminal = terminal;
        }

        @Override
        public ShellWriteSequence writeSequence() {
            return ShellWriteSequence.of(this.terminal);
        }

        @Override
        public NonInteractiveShellSession write(String text) {
            this.terminalSession.getTerminalStarter().sendString(text);
            return this;
        }

        @Override
        public ShellScreen screen() {
            return ShellScreen.of(this.terminalSession.getTerminalTextBuffer().getScreen());
        }

        @Override
        public NonInteractiveShellSession run() {
            NonInteractiveShellRunner runner = new NonInteractiveShellRunner(this.shell, (ShellContext)new DefaultShellContext());
            DefaultApplicationArguments appArgs = new DefaultApplicationArguments(this.args);
            this.blockingQueue.add(new ShellRunnerTaskData((ShellRunner)runner, (ApplicationArguments)appArgs, this.state));
            return this;
        }

        @Override
        public boolean isComplete() {
            return this.state.get() >= 0;
        }
    }

    public static class DefaultInteractiveShellSession
    implements InteractiveShellSession {
        private Shell shell;
        private PromptProvider promptProvider;
        private LineReader lineReader;
        private BlockingQueue<ShellRunnerTaskData> blockingQueue;
        private TerminalSession terminalSession;
        private Terminal terminal;
        private final AtomicInteger state = new AtomicInteger(-2);

        public DefaultInteractiveShellSession(Shell shell, PromptProvider promptProvider, LineReader lineReader, BlockingQueue<ShellRunnerTaskData> blockingQueue, TerminalSession terminalSession, Terminal terminal) {
            this.shell = shell;
            this.promptProvider = promptProvider;
            this.lineReader = lineReader;
            this.blockingQueue = blockingQueue;
            this.terminalSession = terminalSession;
            this.terminal = terminal;
        }

        @Override
        public ShellWriteSequence writeSequence() {
            return ShellWriteSequence.of(this.terminal);
        }

        @Override
        public InteractiveShellSession write(String text) {
            this.terminalSession.getTerminalStarter().sendString(text);
            return this;
        }

        @Override
        public ShellScreen screen() {
            return ShellScreen.of(this.terminalSession.getTerminalTextBuffer().getScreen());
        }

        @Override
        public InteractiveShellSession run() {
            InteractiveShellRunner runner = new InteractiveShellRunner(this.lineReader, this.promptProvider, this.shell, (ShellContext)new DefaultShellContext());
            DefaultApplicationArguments appArgs = new DefaultApplicationArguments(new String[0]);
            this.blockingQueue.add(new ShellRunnerTaskData((ShellRunner)runner, (ApplicationArguments)appArgs, this.state));
            return this;
        }

        @Override
        public boolean isComplete() {
            return this.state.get() >= 0;
        }
    }

    public static class DefaultShellClient
    implements ShellTestClient {
        private static final Logger log = LoggerFactory.getLogger(DefaultShellClient.class);
        private TerminalSession terminalSession;
        private Shell shell;
        private PromptProvider promptProvider;
        private LineReader lineReader;
        private Thread runnerThread;
        private Terminal terminal;
        private final BlockingQueue<ShellRunnerTaskData> blockingQueue = new LinkedBlockingDeque<ShellRunnerTaskData>(10);

        DefaultShellClient(TerminalSession terminalSession, Shell shell, PromptProvider promptProvider, LineReader lineReader, Terminal terminal) {
            this.terminalSession = terminalSession;
            this.shell = shell;
            this.promptProvider = promptProvider;
            this.lineReader = lineReader;
            this.terminal = terminal;
        }

        @Override
        public InteractiveShellSession interactive() {
            this.terminalSession.start();
            if (this.runnerThread == null) {
                this.runnerThread = new Thread(new ShellRunnerTask(this.blockingQueue));
                this.runnerThread.start();
            }
            return new DefaultInteractiveShellSession(this.shell, this.promptProvider, this.lineReader, this.blockingQueue, this.terminalSession, this.terminal);
        }

        @Override
        public NonInteractiveShellSession nonInterative(String ... args) {
            this.terminalSession.start();
            if (this.runnerThread == null) {
                this.runnerThread = new Thread(new ShellRunnerTask(this.blockingQueue));
                this.runnerThread.start();
            }
            return new DefaultNonInteractiveShellSession(this.shell, args, this.blockingQueue, this.terminalSession, this.terminal);
        }

        @Override
        public ShellScreen screen() {
            return ShellScreen.of(this.terminalSession.getTerminalTextBuffer().getScreen());
        }

        @Override
        public void close() throws IOException {
            log.debug("Closing ShellClient");
            if (this.runnerThread != null) {
                this.runnerThread.interrupt();
            }
            this.runnerThread = null;
            this.terminalSession.close();
        }
    }

    public static interface NonInteractiveShellSession
    extends BaseShellSession<NonInteractiveShellSession> {
    }

    public static interface InteractiveShellSession
    extends BaseShellSession<InteractiveShellSession> {
    }

    public static interface BaseShellSession<T extends BaseShellSession<T>> {
        public ShellWriteSequence writeSequence();

        public ShellScreen screen();

        public T write(String var1);

        public T run();

        public boolean isComplete();
    }

    public static interface Builder {
        public ShellTestClient build();
    }
}

