/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.emulator.charset;

import org.springframework.shell.test.jediterm.terminal.emulator.charset.CharacterSet;

public class GraphicSet {
    private final int myIndex;
    private CharacterSet myDesignation;

    public GraphicSet(int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("Invalid index!");
        }
        this.myIndex = index;
        this.myDesignation = CharacterSet.valueOf(index == 1 ? (char)'0' : 'B');
    }

    public CharacterSet getDesignation() {
        return this.myDesignation;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int map(char original, int index) {
        int result = this.myDesignation.map(index);
        if (result < 0) {
            result = original;
        }
        return result;
    }

    public void setDesignation(CharacterSet designation) {
        this.myDesignation = designation;
    }
}

