/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.staticmock;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.runtime.internal.AroundClosure;

@Aspect(value="percflow(mockStaticsTestMethod())")
public abstract class AbstractMethodMockingControl {
    private boolean recording = true;
    private Expectations expectations = new Expectations();

    @Pointcut(value="", argNames="")
    protected abstract /* synthetic */ void ajc$pointcut$$mockStaticsTestMethod$4b1();

    @Pointcut(value="", argNames="")
    protected abstract /* synthetic */ void ajc$pointcut$$methodToMock$4e8();

    @AfterReturning(pointcut="mockStaticsTestMethod()", returning="", argNames="")
    public void ajc$afterReturning$org_springframework_mock_staticmock_AbstractMethodMockingControl$1$94476acf() {
        if (this.recording && this.expectations.hasCalls()) {
            throw new IllegalStateException("Calls recorded, yet playback state never reached: Create expectations then call " + this.getClass().getSimpleName() + ".playback()");
        }
        this.expectations.verify();
    }

    @Around(value="(methodToMock() && cflowbelow(mockStaticsTestMethod()))", argNames="ajc$aroundClosure")
    public Object ajc$around$org_springframework_mock_staticmock_AbstractMethodMockingControl$2$9cfbb496(AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        if (this.recording) {
            this.expectations.expectCall(thisJoinPointStaticPart.toLongString(), thisJoinPoint.getArgs());
            return null;
        }
        return this.expectations.respond(thisJoinPointStaticPart.toLongString(), thisJoinPoint.getArgs());
    }

    static /* synthetic */ Object ajc$around$org_springframework_mock_staticmock_AbstractMethodMockingControl$2$9cfbb496proceed(AroundClosure this_) throws Throwable {
        return this_.run(new Object[0]);
    }

    public void expectReturnInternal(Object retVal) {
        if (!this.recording) {
            throw new IllegalStateException("Not recording: Cannot set return value");
        }
        this.expectations.expectReturn(retVal);
    }

    public void expectThrowInternal(Throwable throwable) {
        if (!this.recording) {
            throw new IllegalStateException("Not recording: Cannot set throwable value");
        }
        this.expectations.expectThrow(throwable);
    }

    public void playbackInternal() {
        this.recording = false;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_springframework_mock_staticmock_AbstractMethodMockingControl$org_springframework_mock_staticmock_AbstractMethodMockingControl$expectations(AbstractMethodMockingControl abstractMethodMockingControl, Expectations expectations) {
        abstractMethodMockingControl.expectations = expectations;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_springframework_mock_staticmock_AbstractMethodMockingControl$org_springframework_mock_staticmock_AbstractMethodMockingControl$recording(AbstractMethodMockingControl abstractMethodMockingControl, boolean bl) {
        abstractMethodMockingControl.recording = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CallResponse {
        nothing,
        return_,
        throw_;

    }

    public class Expectations {
        private List<Call> calls = new LinkedList<Call>();
        private int verified;

        public void verify() {
            if (this.verified != this.calls.size()) {
                throw new IllegalStateException("Expected " + this.calls.size() + " calls, received " + this.verified);
            }
        }

        public Object respond(String lastSig, Object[] args) {
            Call call = this.nextCall();
            CallResponse responseType = call.responseType;
            if (responseType == CallResponse.return_) {
                return call.returnValue(lastSig, args);
            }
            if (responseType == CallResponse.throw_) {
                return call.throwException(lastSig, args);
            }
            throw new IllegalStateException("Behavior of " + call + " not specified");
        }

        private Call nextCall() {
            ++this.verified;
            if (this.verified > this.calls.size()) {
                throw new IllegalStateException("Expected " + this.calls.size() + " calls, received " + this.verified);
            }
            return this.calls.get(this.verified);
        }

        public void expectCall(String lastSig, Object[] lastArgs) {
            Call call = new Call(lastSig, lastArgs);
            this.calls.add(call);
        }

        public boolean hasCalls() {
            return !this.calls.isEmpty();
        }

        public void expectReturn(Object retVal) {
            Call call = this.calls.get(this.calls.size() - 1);
            if (call.hasResponseSpecified()) {
                throw new IllegalStateException("No static method invoked before setting return value");
            }
            call.setReturnVal(retVal);
        }

        public void expectThrow(Throwable throwable) {
            Call call = this.calls.get(this.calls.size() - 1);
            if (call.hasResponseSpecified()) {
                throw new IllegalStateException("No static method invoked before setting throwable");
            }
            call.setThrow(throwable);
        }

        private class Call {
            private final String signature;
            private final Object[] args;
            private Object responseObject;
            private CallResponse responseType = CallResponse.nothing;

            public Call(String name, Object[] args) {
                this.signature = name;
                this.args = args;
            }

            public boolean hasResponseSpecified() {
                return this.responseType != CallResponse.nothing;
            }

            public void setReturnVal(Object retVal) {
                this.responseObject = retVal;
                this.responseType = CallResponse.return_;
            }

            public void setThrow(Throwable throwable) {
                this.responseObject = throwable;
                this.responseType = CallResponse.throw_;
            }

            public Object returnValue(String lastSig, Object[] args) {
                this.checkSignature(lastSig, args);
                return this.responseObject;
            }

            public Object throwException(String lastSig, Object[] args) {
                this.checkSignature(lastSig, args);
                throw (RuntimeException)this.responseObject;
            }

            private void checkSignature(String lastSig, Object[] args) {
                if (!this.signature.equals(lastSig)) {
                    throw new IllegalArgumentException("Signature doesn't match");
                }
                if (!Arrays.equals(this.args, args)) {
                    throw new IllegalArgumentException("Arguments don't match");
                }
            }
        }
    }
}

