/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;

final class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults));
    private static HashMap classCache = new HashMap();
    private BeanInfo beanInfo;
    private HashMap propertyDescriptorMap;
    private HashMap methodDescriptorMap;
    static /* synthetic */ Class class$org$springframework$beans$CachedIntrospectionResults;

    protected static CachedIntrospectionResults forClass(Class clazz) throws BeansException {
        Object o = classCache.get(clazz);
        if (o == null) {
            o = new CachedIntrospectionResults(clazz);
            classCache.put(clazz, o);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using cached introspection results for class " + clazz.getName()));
        }
        return (CachedIntrospectionResults)o;
    }

    private CachedIntrospectionResults(Class clazz) throws BeansException {
        try {
            logger.debug((Object)("Getting BeanInfo for class [" + clazz.getName() + "]"));
            this.beanInfo = Introspector.getBeanInfo(clazz);
            logger.debug((Object)("Caching PropertyDescriptors for class [" + clazz.getName() + "]"));
            this.propertyDescriptorMap = new HashMap();
            PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                logger.debug((Object)("Found property '" + pds[i].getName() + "' of type [" + pds[i].getPropertyType() + "]; editor=[" + pds[i].getPropertyEditorClass() + "]"));
                this.propertyDescriptorMap.put(pds[i].getName(), pds[i]);
            }
            logger.debug((Object)("Caching MethodDescriptors for class [" + clazz.getName() + "]"));
            this.methodDescriptorMap = new HashMap();
            MethodDescriptor[] mds = this.beanInfo.getMethodDescriptors();
            for (int i = 0; i < mds.length; ++i) {
                logger.debug((Object)("Found method '" + mds[i].getName() + "' of type [" + mds[i].getMethod().getReturnType() + "]"));
                this.methodDescriptorMap.put(mds[i].getName(), mds[i]);
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Cannot get BeanInfo for object of class [" + clazz.getName() + "]", ex);
        }
    }

    protected BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    protected Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    protected PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        PropertyDescriptor pd = (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
        if (pd == null) {
            throw new FatalBeanException("No property '" + propertyName + "' in class [" + this.getBeanClass().getName() + "]", null);
        }
        return pd;
    }

    protected MethodDescriptor getMethodDescriptor(String methodName) throws BeansException {
        MethodDescriptor md = (MethodDescriptor)this.methodDescriptorMap.get(methodName);
        if (md == null) {
            throw new FatalBeanException("No method '" + methodName + "' in class [" + this.getBeanClass().getName() + "]", null);
        }
        return md;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

