/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class DefaultBeanFactoryReference
implements BeanFactoryReference {
    private BeanFactory beanFactory;

    public DefaultBeanFactoryReference(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getFactory() {
        BeanFactory retval = this.beanFactory;
        if (retval == null) {
            throw new IllegalStateException("BeanFactory owned by this BeanFactoryReference has been released");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.beanFactory != null) {
            BeanFactory savedFactory;
            DefaultBeanFactoryReference defaultBeanFactoryReference = this;
            synchronized (defaultBeanFactoryReference) {
                savedFactory = this.beanFactory;
                this.beanFactory = null;
            }
            if (savedFactory != null && savedFactory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)savedFactory).destroySingletons();
            }
        }
    }
}

