/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;

public class PropertyAccessExceptionsException
extends BeansException {
    private final BeanWrapper beanWrapper;
    private final PropertyAccessException[] propertyAccessExceptions;

    public PropertyAccessExceptionsException(BeanWrapper beanWrapper, PropertyAccessException[] propertyAccessExceptions) {
        super("");
        this.beanWrapper = beanWrapper;
        this.propertyAccessExceptions = propertyAccessExceptions;
    }

    public BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public Object getBindObject() {
        return this.beanWrapper.getWrappedInstance();
    }

    public int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            if (!propertyName.equals(pae.getPropertyChangeEvent().getPropertyName())) continue;
            return pae;
        }
        return null;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer("Failed properties: ");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            sb.append(this.propertyAccessExceptions[i].getMessage());
            if (i >= this.propertyAccessExceptions.length - 1) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName()).append("; nested PropertyAccessExceptions (");
        sb.append(this.getExceptionCount()).append(") are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            sb.append('\n').append("PropertyAccessException ").append(i + 1).append(": ");
            sb.append((Object)this.propertyAccessExceptions[i]);
        }
        return sb.toString();
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(((Object)((Object)this)).getClass().getName() + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            ps.println("PropertyAccessException " + (i + 1) + ":");
            this.propertyAccessExceptions[i].printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(((Object)((Object)this)).getClass().getName() + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            pw.println("PropertyAccessException " + (i + 1) + ":");
            this.propertyAccessExceptions[i].printStackTrace(pw);
        }
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        if (exClass.isInstance((Object)this)) {
            return true;
        }
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            if (!pae.contains(exClass)) continue;
            return true;
        }
        return false;
    }
}

