/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private boolean allowCircularReferences = true;
    private boolean allowRawInjectionDespiteWrapping = false;
    private final Set ignoredDependencyTypes = new HashSet();
    private final Set ignoredDependencyInterfaces = new HashSet();
    private final ConstructorResolver constructorResolver = new ConstructorResolverAdapter();
    private final Map factoryBeanInstanceCache = new HashMap();
    private final Map filteredPropertyDescriptorsCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanNameAware;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanFactoryAware;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanClassLoaderAware;

    public AbstractAutowireCapableBeanFactory() {
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanNameAware == null ? (class$org$springframework$beans$factory$BeanNameAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanNameAware")) : class$org$springframework$beans$factory$BeanNameAware);
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanFactoryAware == null ? (class$org$springframework$beans$factory$BeanFactoryAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanFactoryAware")) : class$org$springframework$beans$factory$BeanFactoryAware);
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanClassLoaderAware == null ? (class$org$springframework$beans$factory$BeanClassLoaderAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanClassLoaderAware")) : class$org$springframework$beans$factory$BeanClassLoaderAware);
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.setParentBeanFactory(parentBeanFactory);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    protected InstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    public void setAllowRawInjectionDespiteWrapping(boolean allowRawInjectionDespiteWrapping) {
        this.allowRawInjectionDespiteWrapping = allowRawInjectionDespiteWrapping;
    }

    public void ignoreDependencyType(Class type) {
        this.ignoredDependencyTypes.add(type);
    }

    public void ignoreDependencyInterface(Class ifc) {
        this.ignoredDependencyInterfaces.add(ifc);
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory otherAutowireFactory = (AbstractAutowireCapableBeanFactory)otherFactory;
            this.instantiationStrategy = otherAutowireFactory.instantiationStrategy;
            this.allowCircularReferences = otherAutowireFactory.allowCircularReferences;
            this.ignoredDependencyTypes.addAll(otherAutowireFactory.ignoredDependencyTypes);
            this.ignoredDependencyInterfaces.addAll(otherAutowireFactory.ignoredDependencyInterfaces);
        }
    }

    public Object createBean(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setSingleton(false);
        return this.createBean(beanClass.getName(), bd, null);
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setSingleton(false);
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd, null).getWrappedInstance();
        }
        Object bean = this.getInstantiationStrategy().instantiate(bd, null, this);
        this.populateBean(beanClass.getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
        bd.setSingleton(false);
        this.populateBean(existingBean.getClass().getName(), bd, new BeanWrapperImpl(existingBean));
    }

    public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, true);
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.applyPropertyValues(beanName, bd, bw, bd.getPropertyValues());
    }

    public Object configureBean(Object existingBean, String beanName) throws BeansException {
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, true);
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(beanName, bd, bw);
        return this.initializeBean(beanName, existingBean, bd);
    }

    public Object initializeBean(Object existingBean, String beanName) {
        return this.initializeBean(beanName, existingBean, null);
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) throws BeansException {
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, beanName);
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) throws BeansException {
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, beanName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createBean(String beanName, RootBeanDefinition mbd, Object[] args) throws BeanCreationException {
        if (mbd.getDependsOn() != null) {
            for (int i = 0; i < mbd.getDependsOn().length; ++i) {
                this.getBean(mbd.getDependsOn()[i]);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "' with merged definition [" + mbd + "]"));
        }
        Class beanClass = this.resolveBeanClass(mbd, beanName);
        try {
            mbd.prepareMethodOverrides();
        }
        catch (BeanDefinitionValidationException ex) {
            throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "Validation of method overrides failed", (Throwable)((Object)ex));
        }
        String errorMessage = null;
        try {
            Object bean;
            Object bean2;
            errorMessage = "BeanPostProcessor before instantiation of bean failed";
            if (beanClass != null && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (bean2 = this.applyBeanPostProcessorsBeforeInstantiation(beanClass, beanName)) != null) {
                bean2 = this.applyBeanPostProcessorsAfterInitialization(bean2, beanName);
                return bean2;
            }
            errorMessage = "Instantiation of bean failed";
            BeanWrapper instanceWrapper = null;
            if (mbd.isSingleton()) {
                Object object = this.getSingletonMutex();
                synchronized (object) {
                    instanceWrapper = (BeanWrapper)this.factoryBeanInstanceCache.remove(beanName);
                }
            }
            if (instanceWrapper == null) {
                instanceWrapper = this.createBeanInstance(beanName, mbd, args);
            }
            Object object = bean = instanceWrapper != null ? instanceWrapper.getWrappedInstance() : null;
            if (mbd.isSingleton() && this.allowCircularReferences && this.isSingletonCurrentlyInCreation(beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Eagerly caching bean '" + beanName + "' to allow for resolving potential circular references"));
                }
                this.addSingleton(beanName, bean);
            }
            errorMessage = "Initialization of bean failed";
            boolean continueWithPropertyPopulation = true;
            if (!mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
                Iterator it = this.getBeanPostProcessors().iterator();
                while (it.hasNext()) {
                    InstantiationAwareBeanPostProcessor ibp;
                    BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
                    if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (ibp = (InstantiationAwareBeanPostProcessor)beanProcessor).postProcessAfterInstantiation(bean, beanName)) continue;
                    continueWithPropertyPopulation = false;
                    break;
                }
            }
            if (continueWithPropertyPopulation) {
                this.populateBean(beanName, mbd, instanceWrapper);
            }
            Object originalBean = bean;
            bean = this.initializeBean(beanName, bean, mbd);
            if (!this.allowRawInjectionDespiteWrapping && originalBean != bean && mbd.isSingleton() && this.hasDependentBean(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName, "Bean with name '" + beanName + "' has been injected into other beans " + this.getDependentBeans(beanName) + " in its raw version as part of a circular reference, " + "but has eventually been wrapped (for example as part of auto-proxy creation). " + "This means that said other beans do not use the final version of the bean. " + "This is often the result of over-eager type matching - consider using " + "'getBeanNamesOfType' with the 'allowEagerInit' flag turned off, for example.");
            }
            this.registerDisposableBeanIfNecessary(beanName, originalBean, mbd);
            return bean;
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, errorMessage, ex);
        }
    }

    protected Class predictBeanType(String beanName, RootBeanDefinition mbd) {
        Class beanClass = null;
        beanClass = mbd.getFactoryMethodName() != null ? this.getTypeForFactoryMethod(beanName, mbd) : this.resolveBeanClass(mbd, beanName);
        if (!mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            Iterator it = this.getBeanPostProcessors().iterator();
            while (it.hasNext()) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                Class processedType;
                BeanPostProcessor bp = (BeanPostProcessor)it.next();
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor) || (processedType = (ibp = (SmartInstantiationAwareBeanPostProcessor)bp).predictBeanType(beanClass, beanName)) == null) continue;
                return processedType;
            }
        }
        return beanClass;
    }

    protected Class getTypeForFactoryMethod(String beanName, RootBeanDefinition mbd) {
        Class factoryClass = null;
        boolean isStatic = true;
        if (mbd.getFactoryBeanName() != null) {
            factoryClass = this.getType(mbd.getFactoryBeanName());
            isStatic = false;
        } else {
            factoryClass = this.resolveBeanClass(mbd, beanName);
        }
        if (factoryClass == null) {
            return null;
        }
        int minNrOfArgs = mbd.getConstructorArgumentValues().getArgumentCount();
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods((Class)factoryClass);
        HashSet returnTypes = new HashSet(1);
        for (int i = 0; i < candidates.length; ++i) {
            Method factoryMethod = candidates[i];
            if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mbd.getFactoryMethodName()) || factoryMethod.getParameterTypes().length < minNrOfArgs) continue;
            returnTypes.add(factoryMethod.getReturnType());
        }
        if (returnTypes.size() == 1) {
            return (Class)returnTypes.iterator().next();
        }
        return null;
    }

    protected Class getTypeForFactoryBean(String beanName, RootBeanDefinition mbd) {
        FactoryBean fb;
        FactoryBean factoryBean = fb = mbd.isSingleton() ? this.getSingletonFactoryBeanForTypeCheck(beanName, mbd) : this.getNonSingletonFactoryBeanForTypeCheck(beanName, mbd);
        if (fb != null) {
            try {
                Class type = fb.getObjectType();
                if (type != null) {
                    return type;
                }
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", ex);
            }
        }
        return super.getTypeForFactoryBean(beanName, mbd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getSingletonFactoryBeanForTypeCheck(String beanName, RootBeanDefinition mbd) {
        Object object = this.getSingletonMutex();
        synchronized (object) {
            BeanWrapper bw = (BeanWrapper)this.factoryBeanInstanceCache.get(beanName);
            if (bw != null) {
                return (FactoryBean)bw.getWrappedInstance();
            }
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                return null;
            }
            Object instance = null;
            try {
                Object bean;
                this.beforeSingletonCreation(beanName);
                Class beanClass = this.resolveBeanClass(mbd, beanName);
                if (beanClass != null && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (bean = this.applyBeanPostProcessorsBeforeInstantiation(beanClass, beanName)) != null) {
                    instance = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
                }
                if (instance == null) {
                    bw = this.createBeanInstance(beanName, mbd, null);
                    instance = bw.getWrappedInstance();
                }
            }
            finally {
                this.afterSingletonCreation(beanName);
            }
            if (!(instance instanceof FactoryBean)) {
                throw new BeanCreationException(beanName, "Bean instance of type [" + instance.getClass() + "] is not a FactoryBean");
            }
            if (bw != null) {
                this.factoryBeanInstanceCache.put(beanName, bw);
            }
            return (FactoryBean)instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getNonSingletonFactoryBeanForTypeCheck(String beanName, RootBeanDefinition mbd) {
        if (this.isPrototypeCurrentlyInCreation(beanName)) {
            return null;
        }
        Object instance = null;
        try {
            Object bean;
            this.beforePrototypeCreation(beanName);
            Class beanClass = this.resolveBeanClass(mbd, beanName);
            if (beanClass != null && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (bean = this.applyBeanPostProcessorsBeforeInstantiation(beanClass, beanName)) != null) {
                instance = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
            }
            if (instance == null) {
                BeanWrapper bw = this.createBeanInstance(beanName, mbd, null);
                instance = bw.getWrappedInstance();
            }
        }
        finally {
            this.afterPrototypeCreation(beanName);
        }
        if (!(instance instanceof FactoryBean)) {
            throw new BeanCreationException(beanName, "Bean instance of type [" + instance.getClass() + "] is not a FactoryBean");
        }
        return (FactoryBean)instance;
    }

    protected Object applyBeanPostProcessorsBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            InstantiationAwareBeanPostProcessor ibp;
            Object result;
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (result = (ibp = (InstantiationAwareBeanPostProcessor)beanProcessor).postProcessBeforeInstantiation(beanClass, beanName)) == null) continue;
            return result;
        }
        return null;
    }

    protected BeanWrapper createBeanInstance(String beanName, RootBeanDefinition mbd, Object[] args) {
        if (mbd.getFactoryMethodName() != null) {
            return this.instantiateUsingFactoryMethod(beanName, mbd, args);
        }
        Constructor constructor = this.determineConstructorFromBeanPostProcessors(mbd.getBeanClass(), beanName);
        if (constructor != null || mbd.getResolvedAutowireMode() == 3 || mbd.hasConstructorArgumentValues()) {
            return this.autowireConstructor(beanName, mbd, constructor);
        }
        return this.instantiateBean(beanName, mbd);
    }

    protected Constructor determineConstructorFromBeanPostProcessors(Class beanClass, String beanName) throws BeansException {
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            SmartInstantiationAwareBeanPostProcessor ibp;
            Constructor ctor;
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            if (!(beanProcessor instanceof SmartInstantiationAwareBeanPostProcessor) || (ctor = (ibp = (SmartInstantiationAwareBeanPostProcessor)beanProcessor).determineConstructor(beanClass, beanName)) == null) continue;
            return ctor;
        }
        return null;
    }

    protected BeanWrapper instantiateBean(String beanName, RootBeanDefinition mbd) {
        Object beanInstance = this.getInstantiationStrategy().instantiate(mbd, beanName, this);
        BeanWrapperImpl bw = new BeanWrapperImpl(beanInstance);
        this.initBeanWrapper(bw);
        return bw;
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mbd, Object[] explicitArgs) {
        ConstructorResolverAdapter constructorResolver = new ConstructorResolverAdapter();
        return constructorResolver.instantiateUsingFactoryMethod(beanName, mbd, explicitArgs);
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mbd, Constructor ctor) {
        return this.constructorResolver.autowireConstructor(beanName, mbd, ctor);
    }

    protected void populateBean(String beanName, RootBeanDefinition mbd, BeanWrapper bw) {
        boolean needsDepCheck;
        PropertyValues pvs = mbd.getPropertyValues();
        if (bw == null) {
            if (!pvs.isEmpty()) {
                throw new BeanCreationException(beanName, "Cannot apply property values to null instance");
            }
            return;
        }
        if (mbd.getResolvedAutowireMode() == 1 || mbd.getResolvedAutowireMode() == 2) {
            MutablePropertyValues newPvs = new MutablePropertyValues(pvs);
            if (mbd.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mbd, bw, newPvs);
            }
            if (mbd.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mbd, bw, newPvs);
            }
            pvs = newPvs;
        }
        boolean hasInstAwareBpps = this.hasInstantiationAwareBeanPostProcessors();
        boolean bl = needsDepCheck = mbd.getDependencyCheck() != 0;
        if (hasInstAwareBpps || needsDepCheck) {
            PropertyDescriptor[] filteredPds = this.filterPropertyDescriptorsForDependencyCheck(bw);
            if (hasInstAwareBpps) {
                Iterator it = this.getBeanPostProcessors().iterator();
                while (it.hasNext()) {
                    InstantiationAwareBeanPostProcessor ibp;
                    BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
                    if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (pvs = (ibp = (InstantiationAwareBeanPostProcessor)beanProcessor).postProcessPropertyValues(pvs, filteredPds, bw.getWrappedInstance(), beanName)) != null) continue;
                    return;
                }
            }
            if (needsDepCheck) {
                this.checkDependencies(beanName, mbd, filteredPds, pvs);
            }
        }
        this.applyPropertyValues(beanName, mbd, bw, pvs);
    }

    protected void autowireByName(String beanName, RootBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                if (mbd.isSingleton()) {
                    this.registerDependentBean(propertyName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, RootBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Class<?> requiredType = bw.getPropertyDescriptor(propertyName).getPropertyType();
            Map matchingBeans = this.findAutowireCandidates(beanName, requiredType);
            int count = matchingBeans.size();
            if (count == 1) {
                Map.Entry entry = matchingBeans.entrySet().iterator().next();
                String autowiredBeanName = (String)entry.getKey();
                Object autowiredBean = entry.getValue();
                pvs.addPropertyValue(propertyName, autowiredBean);
                if (mbd.isSingleton()) {
                    this.registerDependentBean(autowiredBeanName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + autowiredBeanName + "'"));
                continue;
            }
            if (count > 1) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, propertyName, "There are " + matchingBeans.size() + " beans of type [" + requiredType.getName() + "] available for autowiring by type: " + matchingBeans.keySet() + ". There should have been exactly 1 to be able to autowire property '" + propertyName + "' of bean '" + beanName + "'. Consider using autowiring by name instead.");
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by type: no matching bean found"));
        }
    }

    protected String[] unsatisfiedNonSimpleProperties(RootBeanDefinition mbd, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        MutablePropertyValues pvs = mbd.getPropertyValues();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].getWriteMethod() == null || this.isExcludedFromDependencyCheck(pds[i]) || pvs.contains(pds[i].getName()) || BeanUtils.isSimpleProperty(pds[i].getPropertyType())) continue;
            result.add(pds[i].getName());
        }
        return StringUtils.toStringArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyDescriptor[] filterPropertyDescriptorsForDependencyCheck(BeanWrapper bw) {
        Map map = this.filteredPropertyDescriptorsCache;
        synchronized (map) {
            PropertyDescriptor[] filtered = (PropertyDescriptor[])this.filteredPropertyDescriptorsCache.get(bw.getWrappedClass());
            if (filtered == null) {
                LinkedList<PropertyDescriptor> pds = new LinkedList<PropertyDescriptor>(Arrays.asList(bw.getPropertyDescriptors()));
                Iterator it = pds.iterator();
                while (it.hasNext()) {
                    PropertyDescriptor pd = (PropertyDescriptor)it.next();
                    if (!this.isExcludedFromDependencyCheck(pd)) continue;
                    it.remove();
                }
                filtered = pds.toArray(new PropertyDescriptor[pds.size()]);
                this.filteredPropertyDescriptorsCache.put(bw.getWrappedClass(), filtered);
            }
            return filtered;
        }
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return AutowireUtils.isExcludedFromDependencyCheck(pd) || this.ignoredDependencyTypes.contains(pd.getPropertyType()) || AutowireUtils.isSetterDefinedInInterface(pd, this.ignoredDependencyInterfaces);
    }

    protected void checkDependencies(String beanName, RootBeanDefinition mbd, PropertyDescriptor[] pds, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mbd.getDependencyCheck();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || pvs.contains(pds[i].getName())) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, pds[i].getName(), "Set this property value or disable dependency checking for this bean.");
        }
    }

    protected void applyPropertyValues(String beanName, RootBeanDefinition mbd, BeanWrapper bw, PropertyValues pvs) {
        if (pvs == null || pvs.isEmpty()) {
            return;
        }
        MutablePropertyValues mpvs = null;
        List original = null;
        if (pvs instanceof MutablePropertyValues) {
            mpvs = (MutablePropertyValues)pvs;
            if (mpvs.isConverted()) {
                try {
                    bw.setPropertyValues(mpvs);
                    return;
                }
                catch (BeansException ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", (Throwable)((Object)ex));
                }
            }
            original = mpvs.getPropertyValueList();
        } else {
            original = Arrays.asList(pvs.getPropertyValues());
        }
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this, beanName, mbd, bw);
        BeanWrapperImpl bwi = bw instanceof BeanWrapperImpl ? (BeanWrapperImpl)bw : null;
        ArrayList<PropertyValue> deepCopy = new ArrayList<PropertyValue>(original.size());
        boolean resolveNecessary = false;
        Iterator it = original.iterator();
        while (it.hasNext()) {
            PropertyValue pv = (PropertyValue)it.next();
            if (pv.isConverted()) {
                deepCopy.add(pv);
                continue;
            }
            String propertyName = pv.getName();
            Object originalValue = pv.getValue();
            Object resolvedValue = valueResolver.resolveValueIfNecessary("bean property '" + propertyName + "'", originalValue);
            if (resolvedValue == originalValue) {
                if (bwi != null && !PropertyAccessorUtils.isNestedOrIndexedProperty(propertyName)) {
                    pv.setConvertedValue(bwi.convertForProperty(resolvedValue, propertyName));
                }
                deepCopy.add(pv);
                continue;
            }
            if (originalValue instanceof TypedStringValue && bwi != null && !PropertyAccessorUtils.isNestedOrIndexedProperty(propertyName)) {
                pv.setConvertedValue(bwi.convertForProperty(resolvedValue, propertyName));
                deepCopy.add(pv);
                continue;
            }
            resolveNecessary = true;
            deepCopy.add(new PropertyValue(propertyName, resolvedValue));
        }
        if (mpvs != null && !resolveNecessary) {
            mpvs.setConverted();
        }
        try {
            bw.setPropertyValues(new MutablePropertyValues(deepCopy));
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", (Throwable)((Object)ex));
        }
    }

    protected Object initializeBean(String beanName, Object bean, RootBeanDefinition mbd) {
        if (bean instanceof BeanNameAware) {
            ((BeanNameAware)bean).setBeanName(beanName);
        }
        if (bean instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)bean).setBeanClassLoader(this.getBeanClassLoader());
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory(this);
        }
        Object wrappedBean = bean;
        if (mbd == null || !mbd.isSynthetic()) {
            wrappedBean = this.applyBeanPostProcessorsBeforeInitialization(wrappedBean, beanName);
        }
        try {
            this.invokeInitMethods(beanName, wrappedBean, mbd);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd != null ? mbd.getResourceDescription() : null, beanName, "Invocation of init method failed", ex);
        }
        if (mbd == null || !mbd.isSynthetic()) {
            wrappedBean = this.applyBeanPostProcessorsAfterInitialization(wrappedBean, beanName);
        }
        return wrappedBean;
    }

    protected void invokeInitMethods(String beanName, Object bean, RootBeanDefinition mbd) throws Throwable {
        if (bean instanceof InitializingBean) {
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (mbd != null && mbd.getInitMethodName() != null) {
            this.invokeCustomInitMethod(beanName, bean, mbd.getInitMethodName(), mbd.isEnforceInitMethod());
        }
    }

    protected void invokeCustomInitMethod(String beanName, Object bean, String initMethodName, boolean enforceInitMethod) throws Throwable {
        Method initMethod = BeanUtils.findMethod(bean.getClass(), initMethodName, null);
        if (initMethod == null) {
            if (enforceInitMethod) {
                throw new NoSuchMethodException("Couldn't find an init method named '" + initMethodName + "' on bean with name '" + beanName + "'");
            }
            return;
        }
        if (!Modifier.isPublic(initMethod.getModifiers()) || !Modifier.isPublic(initMethod.getDeclaringClass().getModifiers())) {
            initMethod.setAccessible(true);
        }
        try {
            initMethod.invoke(bean, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) {
        return this.applyBeanPostProcessorsAfterInitialization(object, beanName);
    }

    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanInstanceCache.remove(beanName);
    }

    protected Map findAutowireCandidates(String beanName, Class requiredType) throws BeansException {
        Map result = this.findMatchingBeans(requiredType);
        return result != null ? result : Collections.EMPTY_MAP;
    }

    protected Map findMatchingBeans(Class requiredType) throws BeansException {
        throw new FatalBeanException("Bean lookup by type not supported by this factory");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConstructorResolverAdapter
    extends ConstructorResolver {
        public ConstructorResolverAdapter() {
            super(AbstractAutowireCapableBeanFactory.this, AbstractAutowireCapableBeanFactory.this.getInstantiationStrategy());
        }

        protected Map findAutowireCandidates(String beanName, Class requiredType) throws BeansException {
            return AbstractAutowireCapableBeanFactory.this.findAutowireCandidates(beanName, requiredType);
        }
    }
}

