/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class<?> beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private volatile Set<Method> ambiguousWriteMethods;
    private MethodParameter writeMethodParameter;
    private Class<?> propertyType;
    private final Class<?> propertyEditorClass;

    public GenericTypeAwarePropertyDescriptor(Class<?> beanClass, String propertyName, Method readMethod, Method writeMethod, Class<?> propertyEditorClass) throws IntrospectionException {
        super(propertyName, null, null);
        Method candidate;
        if (beanClass == null) {
            throw new IntrospectionException("Bean class must not be null");
        }
        this.beanClass = beanClass;
        Method readMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)readMethod);
        Method writeMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)writeMethod);
        if (writeMethodToUse == null && readMethodToUse != null && (candidate = ClassUtils.getMethodIfAvailable(this.beanClass, (String)("set" + StringUtils.capitalize((String)this.getName())), (Class[])null)) != null && candidate.getParameterTypes().length == 1) {
            writeMethodToUse = candidate;
        }
        this.readMethod = readMethodToUse;
        this.writeMethod = writeMethodToUse;
        if (this.writeMethod != null && this.readMethod == null) {
            HashSet<Method> ambiguousCandidates = new HashSet<Method>();
            for (Method method : beanClass.getMethods()) {
                if (!method.getName().equals(writeMethodToUse.getName()) || method.equals(writeMethodToUse) || method.isBridge()) continue;
                ambiguousCandidates.add(method);
            }
            if (!ambiguousCandidates.isEmpty()) {
                this.ambiguousWriteMethods = ambiguousCandidates;
            }
        }
        this.propertyEditorClass = propertyEditorClass;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Method getWriteMethodForActualAccess() {
        Set<Method> ambiguousCandidates = this.ambiguousWriteMethods;
        if (ambiguousCandidates != null) {
            this.ambiguousWriteMethods = null;
            LogFactory.getLog(GenericTypeAwarePropertyDescriptor.class).warn((Object)("Invalid JavaBean property '" + this.getName() + "' being accessed! Ambiguous write methods found next to actually used [" + this.writeMethod + "]: " + ambiguousCandidates));
        }
        return this.writeMethod;
    }

    public synchronized MethodParameter getWriteMethodParameter() {
        if (this.writeMethod == null) {
            return null;
        }
        if (this.writeMethodParameter == null) {
            this.writeMethodParameter = new MethodParameter(this.writeMethod, 0);
            GenericTypeResolver.resolveParameterType((MethodParameter)this.writeMethodParameter, this.beanClass);
        }
        return this.writeMethodParameter;
    }

    @Override
    public synchronized Class<?> getPropertyType() {
        if (this.propertyType == null) {
            MethodParameter writeMethodParam;
            this.propertyType = this.readMethod != null ? GenericTypeResolver.resolveReturnType((Method)this.readMethod, this.beanClass) : ((writeMethodParam = this.getWriteMethodParameter()) != null ? writeMethodParam.getParameterType() : super.getPropertyType());
        }
        return this.propertyType;
    }

    @Override
    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericTypeAwarePropertyDescriptor)) {
            return false;
        }
        GenericTypeAwarePropertyDescriptor otherPd = (GenericTypeAwarePropertyDescriptor)other;
        return this.getBeanClass().equals(otherPd.getBeanClass()) && ObjectUtils.nullSafeEquals((Object)this.getReadMethod(), (Object)otherPd.getReadMethod()) && ObjectUtils.nullSafeEquals((Object)this.getWriteMethod(), (Object)otherPd.getWriteMethod()) && ObjectUtils.nullSafeEquals(this.getPropertyEditorClass(), otherPd.getPropertyEditorClass()) && this.isBound() == otherPd.isBound() && this.isConstrained() == otherPd.isConstrained();
    }

    @Override
    public int hashCode() {
        int hashCode = this.getBeanClass().hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getReadMethod());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getWriteMethod());
        return hashCode;
    }
}

