/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.SimpleAliasRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSingletonBeanRegistry
extends SimpleAliasRegistry
implements SingletonBeanRegistry {
    private static final int SUPPRESSED_EXCEPTIONS_LIMIT = 100;
    final Lock singletonLock = new ReentrantLock();
    private final Map<String, Object> singletonObjects = new ConcurrentHashMap<String, Object>(256);
    private final Map<String, ObjectFactory<?>> singletonFactories = new ConcurrentHashMap(16);
    private final Map<String, Consumer<Object>> singletonCallbacks = new ConcurrentHashMap<String, Consumer<Object>>(16);
    private final Map<String, Object> earlySingletonObjects = new ConcurrentHashMap<String, Object>(16);
    private final Set<String> registeredSingletons = Collections.synchronizedSet(new LinkedHashSet(256));
    private final Set<String> singletonsCurrentlyInCreation = ConcurrentHashMap.newKeySet(16);
    private final Set<String> inCreationCheckExclusions = ConcurrentHashMap.newKeySet(16);
    private volatile boolean singletonsCurrentlyInDestruction = false;
    private @Nullable Set<Exception> suppressedExceptions;
    private final Map<String, DisposableBean> disposableBeans = new LinkedHashMap<String, DisposableBean>();
    private final Map<String, Set<String>> containedBeanMap = new ConcurrentHashMap<String, Set<String>>(16);
    private final Map<String, Set<String>> dependentBeanMap = new ConcurrentHashMap<String, Set<String>>(64);
    private final Map<String, Set<String>> dependenciesForBeanMap = new ConcurrentHashMap<String, Set<String>>(64);

    @Override
    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        Assert.notNull((Object)singletonObject, (String)"Singleton object must not be null");
        this.singletonLock.lock();
        try {
            this.addSingleton(beanName, singletonObject);
        }
        finally {
            this.singletonLock.unlock();
        }
    }

    protected void addSingleton(String beanName, Object singletonObject) {
        Object oldObject = this.singletonObjects.putIfAbsent(beanName, singletonObject);
        if (oldObject != null) {
            throw new IllegalStateException("Could not register object [" + String.valueOf(singletonObject) + "] under bean name '" + beanName + "': there is already object [" + String.valueOf(oldObject) + "] bound");
        }
        this.singletonFactories.remove(beanName);
        this.earlySingletonObjects.remove(beanName);
        this.registeredSingletons.add(beanName);
        Consumer<Object> callback = this.singletonCallbacks.get(beanName);
        if (callback != null) {
            callback.accept(singletonObject);
        }
    }

    protected void addSingletonFactory(String beanName, ObjectFactory<?> singletonFactory) {
        Assert.notNull(singletonFactory, (String)"Singleton factory must not be null");
        this.singletonFactories.put(beanName, singletonFactory);
        this.earlySingletonObjects.remove(beanName);
        this.registeredSingletons.add(beanName);
    }

    @Override
    public void addSingletonCallback(String beanName, Consumer<Object> singletonConsumer) {
        this.singletonCallbacks.put(beanName, singletonConsumer);
    }

    @Override
    public @Nullable Object getSingleton(String beanName) {
        return this.getSingleton(beanName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Object getSingleton(String beanName, boolean allowEarlyReference) {
        Object singletonObject = this.singletonObjects.get(beanName);
        if (singletonObject == null && this.isSingletonCurrentlyInCreation(beanName) && (singletonObject = this.earlySingletonObjects.get(beanName)) == null && allowEarlyReference) {
            if (!this.singletonLock.tryLock()) {
                return null;
            }
            try {
                ObjectFactory<?> singletonFactory;
                singletonObject = this.singletonObjects.get(beanName);
                if (singletonObject == null && (singletonObject = this.earlySingletonObjects.get(beanName)) == null && (singletonFactory = this.singletonFactories.get(beanName)) != null) {
                    singletonObject = singletonFactory.getObject();
                    if (this.singletonFactories.remove(beanName) != null) {
                        this.earlySingletonObjects.put(beanName, singletonObject);
                    } else {
                        singletonObject = this.singletonObjects.get(beanName);
                    }
                }
            }
            finally {
                this.singletonLock.unlock();
            }
        }
        return singletonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getSingleton(String beanName, ObjectFactory<?> singletonFactory) {
        block24: {
            Assert.notNull((Object)beanName, (String)"Bean name must not be null");
            lockFlag = this.isCurrentThreadAllowedToHoldSingletonLock();
            acquireLock = Boolean.FALSE.equals(lockFlag) == false;
            locked = acquireLock != false && this.singletonLock.tryLock() != false;
            singletonObject = this.singletonObjects.get(beanName);
            if (singletonObject != null) return singletonObject;
            if (!acquireLock || locked) ** GOTO lbl25
            if (!Boolean.TRUE.equals(lockFlag)) break block24;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creating singleton bean '" + beanName + "' in thread \"" + Thread.currentThread().getName() + "\" while other thread holds singleton lock for other beans " + String.valueOf(this.singletonsCurrentlyInCreation)));
            }
            ** GOTO lbl25
        }
        this.singletonLock.lock();
        locked = true;
        singletonObject = this.singletonObjects.get(beanName);
        if (singletonObject != null) {
            var7_7 = singletonObject;
            if (locked == false) return var7_7;
            this.singletonLock.unlock();
            return var7_7;
        }
        {
            catch (Throwable var13_18) {
                throw var13_18;
            }
lbl25:
            // 3 sources

            if (this.singletonsCurrentlyInDestruction) {
                throw new BeanCreationNotAllowedException(beanName, "Singleton bean creation not allowed while singletons of this factory are in destruction (Do not request a bean from a BeanFactory in a destroy method implementation!)");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
            }
            try {
                this.beforeSingletonCreation(beanName);
                ** GOTO lbl44
            }
            catch (BeanCurrentlyInCreationException ex) {}
            if (locked) {
                throw ex;
            }
            this.singletonLock.lock();
            locked = true;
            singletonObject = this.singletonObjects.get(beanName);
            if (singletonObject == null) ** GOTO lbl-1000
            var8_11 = singletonObject;
            if (locked == false) return var8_11;
            this.singletonLock.unlock();
            return var8_11;
lbl-1000:
            // 1 sources

            {
                this.beforeSingletonCreation(beanName);
lbl44:
                // 2 sources

                newSingleton = false;
                v0 = recordSuppressedExceptions = locked != false && this.suppressedExceptions == null;
                if (recordSuppressedExceptions) {
                    this.suppressedExceptions = new LinkedHashSet<Exception>();
                }
                try {
                    singletonObject = singletonFactory.getObject();
                    newSingleton = true;
                }
                catch (IllegalStateException ex) {
                    singletonObject = this.singletonObjects.get(beanName);
                    if (singletonObject == null) {
                        throw ex;
                    }
                }
                catch (BeanCreationException ex) {
                    if (recordSuppressedExceptions == false) throw ex;
                    var10_15 = this.suppressedExceptions.iterator();
                    while (var10_15.hasNext() != false) {
                        suppressedException = var10_15.next();
                        ex.addRelatedCause(suppressedException);
                    }
                    throw ex;
                }
                finally {
                    if (recordSuppressedExceptions) {
                        this.suppressedExceptions = null;
                    }
                    this.afterSingletonCreation(beanName);
                }
                if (newSingleton == false) return singletonObject;
                this.addSingleton(beanName, singletonObject);
                return singletonObject;
            }
        }
    }

    protected @Nullable Boolean isCurrentThreadAllowedToHoldSingletonLock() {
        return null;
    }

    protected void onSuppressedException(Exception ex) {
        if (this.suppressedExceptions != null && this.suppressedExceptions.size() < 100) {
            this.suppressedExceptions.add(ex);
        }
    }

    protected void removeSingleton(String beanName) {
        this.singletonObjects.remove(beanName);
        this.singletonFactories.remove(beanName);
        this.earlySingletonObjects.remove(beanName);
        this.registeredSingletons.remove(beanName);
    }

    @Override
    public boolean containsSingleton(String beanName) {
        return this.singletonObjects.containsKey(beanName);
    }

    @Override
    public String[] getSingletonNames() {
        return StringUtils.toStringArray(this.registeredSingletons);
    }

    @Override
    public int getSingletonCount() {
        return this.registeredSingletons.size();
    }

    public void setCurrentlyInCreation(String beanName, boolean inCreation) {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        if (!inCreation) {
            this.inCreationCheckExclusions.add(beanName);
        } else {
            this.inCreationCheckExclusions.remove(beanName);
        }
    }

    public boolean isCurrentlyInCreation(String beanName) {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        return !this.inCreationCheckExclusions.contains(beanName) && this.isActuallyInCreation(beanName);
    }

    protected boolean isActuallyInCreation(String beanName) {
        return this.isSingletonCurrentlyInCreation(beanName);
    }

    public boolean isSingletonCurrentlyInCreation(@Nullable String beanName) {
        return this.singletonsCurrentlyInCreation.contains(beanName);
    }

    protected void beforeSingletonCreation(String beanName) {
        if (!this.inCreationCheckExclusions.contains(beanName) && !this.singletonsCurrentlyInCreation.add(beanName)) {
            throw new BeanCurrentlyInCreationException(beanName);
        }
    }

    protected void afterSingletonCreation(String beanName) {
        if (!this.inCreationCheckExclusions.contains(beanName) && !this.singletonsCurrentlyInCreation.remove(beanName)) {
            throw new IllegalStateException("Singleton '" + beanName + "' isn't currently in creation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisposableBean(String beanName, DisposableBean bean) {
        Map<String, DisposableBean> map = this.disposableBeans;
        synchronized (map) {
            this.disposableBeans.put(beanName, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContainedBean(String containedBeanName, String containingBeanName) {
        Map<String, Set<String>> map = this.containedBeanMap;
        synchronized (map) {
            Set containedBeans = this.containedBeanMap.computeIfAbsent(containingBeanName, k -> new LinkedHashSet(8));
            if (!containedBeans.add(containedBeanName)) {
                return;
            }
        }
        this.registerDependentBean(containedBeanName, containingBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentBean(String beanName, String dependentBeanName) {
        String canonicalName = this.canonicalName(beanName);
        Map<String, Set<String>> map = this.dependentBeanMap;
        synchronized (map) {
            Set dependentBeans = this.dependentBeanMap.computeIfAbsent(canonicalName, k -> new LinkedHashSet(8));
            if (!dependentBeans.add(dependentBeanName)) {
                return;
            }
        }
        map = this.dependenciesForBeanMap;
        synchronized (map) {
            Set dependenciesForBean = this.dependenciesForBeanMap.computeIfAbsent(dependentBeanName, k -> new LinkedHashSet(8));
            dependenciesForBean.add(canonicalName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDependent(String beanName, String dependentBeanName) {
        Map<String, Set<String>> map = this.dependentBeanMap;
        synchronized (map) {
            return this.isDependent(beanName, dependentBeanName, null);
        }
    }

    private boolean isDependent(String beanName, String dependentBeanName, @Nullable Set<String> alreadySeen) {
        if (alreadySeen != null && alreadySeen.contains(beanName)) {
            return false;
        }
        String canonicalName = this.canonicalName(beanName);
        Set<String> dependentBeans = this.dependentBeanMap.get(canonicalName);
        if (dependentBeans == null || dependentBeans.isEmpty()) {
            return false;
        }
        if (dependentBeans.contains(dependentBeanName)) {
            return true;
        }
        if (alreadySeen == null) {
            alreadySeen = new HashSet<String>();
        }
        alreadySeen.add(beanName);
        for (String transitiveDependency : dependentBeans) {
            if (!this.isDependent(transitiveDependency, dependentBeanName, alreadySeen)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDependentBean(String beanName) {
        return this.dependentBeanMap.containsKey(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDependentBeans(String beanName) {
        Set<String> dependentBeans = this.dependentBeanMap.get(beanName);
        if (dependentBeans == null) {
            return new String[0];
        }
        Map<String, Set<String>> map = this.dependentBeanMap;
        synchronized (map) {
            return StringUtils.toStringArray(dependentBeans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDependenciesForBean(String beanName) {
        Set<String> dependenciesForBean = this.dependenciesForBeanMap.get(beanName);
        if (dependenciesForBean == null) {
            return new String[0];
        }
        Map<String, Set<String>> map = this.dependenciesForBeanMap;
        synchronized (map) {
            return StringUtils.toStringArray(dependenciesForBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        String[] disposableBeanNames;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Destroying singletons in " + String.valueOf(this)));
        }
        this.singletonsCurrentlyInDestruction = true;
        Map<String, DisposableBean> map = this.disposableBeans;
        synchronized (map) {
            disposableBeanNames = StringUtils.toStringArray(this.disposableBeans.keySet());
        }
        for (int i = disposableBeanNames.length - 1; i >= 0; --i) {
            this.destroySingleton(disposableBeanNames[i]);
        }
        this.containedBeanMap.clear();
        this.dependentBeanMap.clear();
        this.dependenciesForBeanMap.clear();
        this.singletonLock.lock();
        try {
            this.clearSingletonCache();
        }
        finally {
            this.singletonLock.unlock();
        }
    }

    protected void clearSingletonCache() {
        this.singletonObjects.clear();
        this.singletonFactories.clear();
        this.earlySingletonObjects.clear();
        this.registeredSingletons.clear();
        this.singletonsCurrentlyInDestruction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingleton(String beanName) {
        DisposableBean disposableBean;
        Map<String, DisposableBean> map = this.disposableBeans;
        synchronized (map) {
            disposableBean = this.disposableBeans.remove(beanName);
        }
        this.destroyBean(beanName, disposableBean);
        if (!this.singletonsCurrentlyInDestruction) {
            this.singletonLock.lock();
            try {
                this.removeSingleton(beanName);
            }
            finally {
                this.singletonLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBean(String beanName, @Nullable DisposableBean bean) {
        Set<String> containedBeans;
        block18: {
            Set<String> dependentBeanNames;
            Map<String, Set<String>> map = this.dependentBeanMap;
            synchronized (map) {
                dependentBeanNames = this.dependentBeanMap.remove(beanName);
            }
            if (dependentBeanNames != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Retrieved dependent beans for bean '" + beanName + "': " + String.valueOf(dependentBeanNames)));
                }
                for (String dependentBeanName : dependentBeanNames) {
                    this.destroySingleton(dependentBeanName);
                }
            }
            if (bean != null) {
                try {
                    bean.destroy();
                }
                catch (Throwable ex) {
                    if (!this.logger.isWarnEnabled()) break block18;
                    this.logger.warn((Object)("Destruction of bean with name '" + beanName + "' threw an exception"), ex);
                }
            }
        }
        Map<String, Set<String>> map = this.containedBeanMap;
        synchronized (map) {
            containedBeans = this.containedBeanMap.remove(beanName);
        }
        if (containedBeans != null) {
            for (String containedBeanName : containedBeans) {
                this.destroySingleton(containedBeanName);
            }
        }
        map = this.dependentBeanMap;
        synchronized (map) {
            Iterator<Map.Entry<String, Set<String>>> it = this.dependentBeanMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<String>> entry = it.next();
                Set<String> dependenciesToClean = entry.getValue();
                dependenciesToClean.remove(beanName);
                if (!dependenciesToClean.isEmpty()) continue;
                it.remove();
            }
        }
        this.dependenciesForBeanMap.remove(beanName);
    }

    @Override
    @Deprecated(since="6.2")
    public final Object getSingletonMutex() {
        return new Object();
    }
}

