/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.MappingContext;
import org.springframework.core.style.ToStringCreator;

public class DefaultAttributeMapper
implements AttributeMapper {
    private List mappings = new LinkedList();

    public DefaultAttributeMapper addMapping(AttributeMapper mapping) {
        this.mappings.add(mapping);
        return this;
    }

    public void addMappings(AttributeMapper[] mappings) {
        if (mappings == null) {
            return;
        }
        this.mappings.addAll(Arrays.asList(mappings));
    }

    public AttributeMapper[] getMappings() {
        return this.mappings.toArray(new AttributeMapper[this.mappings.size()]);
    }

    public void map(Object source, Object target, MappingContext context) {
        if (this.mappings != null) {
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                AttributeMapper mapping = (AttributeMapper)it.next();
                mapping.map(source, target, context);
            }
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("mappings", (Object)this.mappings).toString();
    }
}

