/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.guava;

import java.io.Serializable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class GuavaCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final String name;
    private final com.google.common.cache.Cache<Object, Object> cache;
    private final boolean allowNullValues;

    public GuavaCache(String name, com.google.common.cache.Cache<Object, Object> cache) {
        this(name, cache, true);
    }

    public GuavaCache(String name, com.google.common.cache.Cache<Object, Object> cache, boolean allowNullValues) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull(cache, (String)"Cache must not be null");
        this.name = name;
        this.cache = cache;
        this.allowNullValues = allowNullValues;
    }

    public String getName() {
        return this.name;
    }

    public com.google.common.cache.Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.cache.getIfPresent(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.cache.getIfPresent(key));
        if (type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    public void evict(Object key) {
        this.cache.invalidate(key);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }
    }
}

