/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.AbstractJndiLocator;

public abstract class AbstractSlsbInvokerInterceptor
extends AbstractJndiLocator
implements MethodInterceptor,
InitializingBean {
    private Method createMethod;
    private Object cachedHome;

    protected Object getCachedEjbHome() {
        return this.cachedHome;
    }

    protected void located(Object jndiObject) {
        this.cachedHome = jndiObject;
        try {
            this.createMethod = this.cachedHome.getClass().getMethod("create", null);
        }
        catch (NoSuchMethodException ex) {
            throw new FatalBeanException("Cannot create EJB proxy: EJB home [" + this.cachedHome + "] has no no-arg create() method");
        }
        this.afterLocated();
    }

    protected void afterLocated() {
    }

    protected Object create() throws InvocationTargetException {
        try {
            return this.createMethod.invoke(this.cachedHome, null);
        }
        catch (IllegalArgumentException ex) {
            throw new FatalBeanException("Inconsistent state: could not call ejbCreate() method without arguments", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new FatalBeanException("Could not access ejbCreate() method", (Throwable)ex);
        }
    }
}

