/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.support;

import javax.ejb.EnterpriseBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.context.access.JndiBeanFactoryLocator;

abstract class AbstractEnterpriseBean
implements EnterpriseBean {
    public static final String BEAN_FACTORY_PATH_ENVIRONMENT_KEY = "java:comp/env/ejb/BeanFactoryPath";
    protected Log logger = LogFactory.getLog(this.getClass());
    private BeanFactoryLocator beanFactoryLocator;
    private String factoryKey;
    private BeanFactoryReference beanFactoryRef;

    AbstractEnterpriseBean() {
    }

    void loadBeanFactory() throws BootstrapException {
        if (this.beanFactoryLocator == null) {
            this.beanFactoryLocator = new JndiBeanFactoryLocator();
            this.factoryKey = BEAN_FACTORY_PATH_ENVIRONMENT_KEY;
        }
        this.beanFactoryRef = this.beanFactoryLocator.useFactory(this.factoryKey);
    }

    void unloadBeanFactory() throws FatalBeanException {
        if (this.beanFactoryRef != null) {
            this.beanFactoryRef.release();
            this.beanFactoryRef = null;
        }
    }

    public void setBeanFactoryLocator(BeanFactoryLocator beanFactoryLocator) {
        this.beanFactoryLocator = beanFactoryLocator;
    }

    public void setBeanFactoryLocatorKey(String factoryKey) {
        this.factoryKey = factoryKey;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactoryRef.getFactory();
    }

    public void ejbRemove() {
    }
}

