/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalObject;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.ejb.access.AbstractSlsbInvokerInterceptor;

public class LocalSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    protected EJBLocalObject newSessionBeanInstance() throws InvocationTargetException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Trying to create reference to local EJB");
        }
        EJBLocalObject session = (EJBLocalObject)this.create();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained reference to local EJB: " + session));
        }
        return session;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            EJBLocalObject ejb = this.newSessionBeanInstance();
            return invocation.getMethod().invoke((Object)ejb, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            this.logger.info((Object)("Method of local EJB [" + this.getJndiName() + "] threw exception"), targetException);
            if (targetException instanceof CreateException) {
                throw new AspectException("Could not create local EJB [" + this.getJndiName() + "]", targetException);
            }
            throw targetException;
        }
        catch (Throwable ex) {
            throw new AspectException("Failed to invoke local EJB [" + this.getJndiName() + "]", ex);
        }
    }
}

