/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ResourceEntityResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.xml.sax.EntityResolver;

public abstract class AbstractXmlApplicationContext
extends AbstractApplicationContext {
    private ConfigurableListableBeanFactory beanFactory;

    public AbstractXmlApplicationContext() {
    }

    public AbstractXmlApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    protected final void refreshBeanFactory() throws BeansException {
        if (this.beanFactory != null) {
            this.beanFactory.destroySingletons();
            this.beanFactory = null;
        }
        try {
            DefaultListableBeanFactory beanFactory = this.createBeanFactory();
            XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
            beanDefinitionReader.setEntityResolver((EntityResolver)((Object)new ResourceEntityResolver(this)));
            this.initBeanDefinitionReader(beanDefinitionReader);
            this.loadBeanDefinitions(beanDefinitionReader);
            this.beanFactory = beanFactory;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bean factory for application context [" + this.getDisplayName() + "]: " + beanFactory));
            }
        }
        catch (IOException ex) {
            throw new ApplicationContextException("I/O error parsing XML document for application context [" + this.getDisplayName() + "]", ex);
        }
    }

    public final ConfigurableListableBeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory not initialized - call 'refresh' before accessing beans via the context: " + this);
        }
        return this.beanFactory;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory(this.getInternalParentBeanFactory());
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        String[] configLocations = this.getConfigLocations();
        if (configLocations != null) {
            ResourcePatternResolver resourcePatternResolver = this.getResourcePatternResolver();
            for (int i = 0; i < configLocations.length; ++i) {
                Resource[] configResources = resourcePatternResolver.getResources(configLocations[i]);
                for (int j = 0; j < configResources.length; ++j) {
                    reader.loadBeanDefinitions(configResources[j]);
                }
            }
        }
    }

    protected abstract String[] getConfigLocations();
}

