/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;

public class ModelMap
extends HashMap {
    public ModelMap() {
    }

    public ModelMap(String modelName, Object modelObject) {
        this.addObject(modelName, modelObject);
    }

    public ModelMap(Object modelObject) {
        this.addObject(modelObject);
    }

    public ModelMap addObject(String modelName, Object modelObject) {
        Assert.notNull((Object)modelName, (String)"Model name must not be null");
        this.put(modelName, modelObject);
        return this;
    }

    public ModelMap addObject(Object modelObject) {
        Assert.notNull((Object)modelObject, (String)"Model object must not be null");
        if (modelObject instanceof Collection && ((Collection)modelObject).isEmpty()) {
            return this;
        }
        return this.addObject(Conventions.getVariableName((Object)modelObject), modelObject);
    }

    public ModelMap addAllObjects(Map objects) {
        if (objects != null) {
            this.putAll(objects);
        }
        return this;
    }

    public ModelMap addAllObjects(Collection objects) {
        if (objects != null) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                this.addObject(it.next());
            }
        }
        return this;
    }
}

