/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.scheduling.timer.ScheduledTimerTask;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TimerFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledTimerTask[] scheduledTimerTasks;
    private boolean daemon = false;
    private String beanName;
    private Timer timer;
    static /* synthetic */ Class class$java$util$Timer;

    public void setScheduledTimerTasks(ScheduledTimerTask[] scheduledTimerTasks) {
        this.scheduledTimerTasks = scheduledTimerTasks;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        this.logger.info((Object)"Initializing Timer");
        this.timer = this.createTimer(this.beanName, this.daemon);
        if (!ObjectUtils.isEmpty((Object[])this.scheduledTimerTasks)) {
            this.registerTasks(this.scheduledTimerTasks, this.timer);
        }
    }

    protected Timer createTimer(String name, boolean daemon) {
        Timer timer = this.createTimer(daemon);
        if (timer != null) {
            return timer;
        }
        if (StringUtils.hasText((String)name) && JdkVersion.isAtLeastJava15()) {
            return new Timer(name, daemon);
        }
        return new Timer(daemon);
    }

    protected Timer createTimer(boolean daemon) {
        return null;
    }

    protected void registerTasks(ScheduledTimerTask[] tasks, Timer timer) {
        for (int i = 0; i < tasks.length; ++i) {
            ScheduledTimerTask task = tasks[i];
            if (task.isOneTimeTask()) {
                timer.schedule(task.getTimerTask(), task.getDelay());
                continue;
            }
            if (task.isFixedRate()) {
                timer.scheduleAtFixedRate(task.getTimerTask(), task.getDelay(), task.getPeriod());
                continue;
            }
            timer.schedule(task.getTimerTask(), task.getDelay(), task.getPeriod());
        }
    }

    public Object getObject() {
        return this.timer;
    }

    public Class getObjectType() {
        return class$java$util$Timer == null ? (class$java$util$Timer = TimerFactoryBean.class$("java.util.Timer")) : class$java$util$Timer;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Cancelling Timer");
        this.timer.cancel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

