/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;

public abstract class RdbmsOperation
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdbcTemplate jdbcTemplate = new JdbcTemplate();
    private List declaredParameters = new LinkedList();
    private String sql;
    private boolean compiled;

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setTypes(int[] types) throws InvalidDataAccessApiUsageException {
        if (this.compiled) {
            throw new InvalidDataAccessApiUsageException("Cannot add parameters once query is compiled");
        }
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.declareParameter(new SqlParameter(types[i]));
            }
        }
    }

    public void declareParameter(SqlParameter param) throws InvalidDataAccessApiUsageException {
        if (this.compiled) {
            throw new InvalidDataAccessApiUsageException("Cannot add parameters once query is compiled");
        }
        this.declaredParameters.add(param);
    }

    protected List getDeclaredParameters() {
        return this.declaredParameters;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void afterPropertiesSet() {
        this.compile();
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public final void compile() throws InvalidDataAccessApiUsageException {
        if (!this.isCompiled()) {
            if (this.getSql() == null) {
                throw new InvalidDataAccessApiUsageException("Sql must be set in class " + this.getClass().getName());
            }
            try {
                this.jdbcTemplate.afterPropertiesSet();
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException(ex.getMessage());
            }
            this.compileInternal();
            this.compiled = true;
            this.logger.info((Object)("RdbmsOperation with SQL [" + this.getSql() + "] compiled"));
        }
    }

    protected abstract void compileInternal() throws InvalidDataAccessApiUsageException;

    protected void validateParameters(Object[] parameters) throws InvalidDataAccessApiUsageException {
        if (!this.compiled) {
            this.logger.info((Object)"SQL operation not compiled before execution - invoking compile");
            this.compile();
        }
        int declaredInParameters = 0;
        if (this.declaredParameters != null) {
            Iterator iter = this.declaredParameters.iterator();
            while (iter.hasNext()) {
                Object p = iter.next();
                if (p instanceof SqlOutParameter || p instanceof SqlReturnResultSet) continue;
                ++declaredInParameters;
            }
        }
        if (parameters != null) {
            if (this.declaredParameters == null) {
                throw new InvalidDataAccessApiUsageException("Didn't expect any parameters: none was declared");
            }
            if (parameters.length < declaredInParameters) {
                throw new InvalidDataAccessApiUsageException(parameters.length + " parameters were supplied, but " + declaredInParameters + " in parameters were declared in class " + this.getClass().getName());
            }
            if (parameters.length > this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException(parameters.length + " parameters were supplied, but " + this.declaredParameters.size() + " parameters were declared in class " + this.getClass().getName());
            }
        } else if (!this.declaredParameters.isEmpty()) {
            throw new InvalidDataAccessApiUsageException(this.declaredParameters.size() + " parameters must be supplied");
        }
    }
}

