/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Constants;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractPlatformTransactionManager
implements PlatformTransactionManager {
    public static final int SYNCHRONIZATION_ALWAYS = 0;
    public static final int SYNCHRONIZATION_ON_ACTUAL_TRANSACTION = 1;
    public static final int SYNCHRONIZATION_NEVER = 2;
    private static final Constants constants = new Constants(class$org$springframework$transaction$support$AbstractPlatformTransactionManager == null ? (class$org$springframework$transaction$support$AbstractPlatformTransactionManager = AbstractPlatformTransactionManager.class$("org.springframework.transaction.support.AbstractPlatformTransactionManager")) : class$org$springframework$transaction$support$AbstractPlatformTransactionManager);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int transactionSynchronization = 0;
    private boolean rollbackOnCommitFailure = false;
    static /* synthetic */ Class class$org$springframework$transaction$support$AbstractPlatformTransactionManager;

    public void setTransactionSynchronizationName(String constantName) {
        this.setTransactionSynchronization(constants.asNumber(constantName).intValue());
    }

    public void setTransactionSynchronization(int transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    public int getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    public void setRollbackOnCommitFailure(boolean rollbackOnCommitFailure) {
        this.rollbackOnCommitFailure = rollbackOnCommitFailure;
    }

    public boolean isRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    public final TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        Object transaction = this.doGetTransaction();
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug((Object)("Using transaction object [" + transaction + "]"));
        }
        if (definition == null) {
            definition = new DefaultTransactionDefinition();
        }
        if (this.isExistingTransaction(transaction)) {
            if (definition.getPropagationBehavior() == 5) {
                throw new IllegalTransactionStateException("Transaction propagation 'never' but existing transaction found");
            }
            if (definition.getPropagationBehavior() == 4) {
                if (debugEnabled) {
                    this.logger.debug((Object)"Suspending current transaction");
                }
                Object suspendedResources = this.suspend(transaction);
                boolean newSynchronization = this.transactionSynchronization == 0;
                return this.newTransactionStatus(null, false, newSynchronization, definition.isReadOnly(), debugEnabled, suspendedResources);
            }
            if (definition.getPropagationBehavior() == 3) {
                if (debugEnabled) {
                    this.logger.debug((Object)"Creating new transaction, suspending current one");
                }
                Object suspendedResources = this.suspend(transaction);
                this.doBegin(transaction, definition);
                boolean newSynchronization = this.transactionSynchronization != 2;
                return this.newTransactionStatus(transaction, true, newSynchronization, definition.isReadOnly(), debugEnabled, suspendedResources);
            }
            if (debugEnabled) {
                this.logger.debug((Object)"Participating in existing transaction");
            }
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(transaction, false, newSynchronization, definition.isReadOnly(), debugEnabled, null);
        }
        if (definition.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", definition.getTimeout());
        }
        if (definition.getPropagationBehavior() == 2) {
            throw new IllegalTransactionStateException("Transaction propagation 'mandatory' but no existing transaction found");
        }
        if (definition.getPropagationBehavior() == 0 || definition.getPropagationBehavior() == 3) {
            if (debugEnabled) {
                this.logger.debug((Object)"Creating new transaction");
            }
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(transaction, true, newSynchronization, definition.isReadOnly(), debugEnabled, null);
        }
        boolean newSynchronization = this.transactionSynchronization == 0;
        return this.newTransactionStatus(null, false, newSynchronization, definition.isReadOnly(), debugEnabled, null);
    }

    private TransactionStatus newTransactionStatus(Object transaction, boolean newTransaction, boolean newSynchronization, boolean readOnly, boolean debug, Object suspendedResources) {
        boolean actualNewSynchronization;
        boolean bl = actualNewSynchronization = newSynchronization && !TransactionSynchronizationManager.isSynchronizationActive();
        if (actualNewSynchronization) {
            TransactionSynchronizationManager.initSynchronization();
        }
        return new DefaultTransactionStatus(transaction, newTransaction, actualNewSynchronization, readOnly, debug, suspendedResources);
    }

    private Object suspend(Object transaction) throws TransactionException {
        List suspendedSynchronizations = null;
        Object holder = this.doSuspend(transaction);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            suspendedSynchronizations = TransactionSynchronizationManager.getSynchronizations();
            Iterator it = suspendedSynchronizations.iterator();
            while (it.hasNext()) {
                ((TransactionSynchronization)it.next()).suspend();
            }
            TransactionSynchronizationManager.clearSynchronization();
        }
        return new SuspendedResourcesHolder(suspendedSynchronizations, holder);
    }

    private void resume(Object transaction, Object suspendedResources) throws TransactionException {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (resourcesHolder.getSuspendedSynchronizations() != null) {
            TransactionSynchronizationManager.initSynchronization();
            Iterator it = resourcesHolder.getSuspendedSynchronizations().iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                synchronization.resume();
                TransactionSynchronizationManager.registerSynchronization(synchronization);
            }
        }
        this.doResume(transaction, resourcesHolder.getSuspendedResources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(TransactionStatus status) throws TransactionException {
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        if (status.isRollbackOnly() || defStatus.getTransaction() != null && this.isRollbackOnly(defStatus.getTransaction())) {
            if (defStatus.isDebug()) {
                this.logger.debug((Object)"Transactional code has requested rollback");
            }
            this.rollback(status);
        } else {
            try {
                boolean beforeCompletionInvoked = false;
                try {
                    this.triggerBeforeCommit(defStatus);
                    this.triggerBeforeCompletion(defStatus, null);
                    beforeCompletionInvoked = true;
                    if (status.isNewTransaction()) {
                        this.logger.info((Object)"Initiating transaction commit");
                        this.doCommit(defStatus);
                    }
                }
                catch (UnexpectedRollbackException ex) {
                    this.triggerAfterCompletion(defStatus, 1, (Throwable)((Object)ex));
                    throw ex;
                }
                catch (TransactionException ex) {
                    if (this.rollbackOnCommitFailure) {
                        this.doRollbackOnCommitException(defStatus, (Throwable)((Object)ex));
                    } else {
                        this.triggerAfterCompletion(defStatus, 2, (Throwable)((Object)ex));
                    }
                    throw ex;
                }
                catch (RuntimeException ex) {
                    if (!beforeCompletionInvoked) {
                        this.triggerBeforeCompletion(defStatus, ex);
                    }
                    this.doRollbackOnCommitException(defStatus, ex);
                    throw ex;
                }
                catch (Error err) {
                    if (!beforeCompletionInvoked) {
                        this.triggerBeforeCompletion(defStatus, err);
                    }
                    this.doRollbackOnCommitException(defStatus, err);
                    throw err;
                }
                this.triggerAfterCompletion(defStatus, 0, null);
            }
            finally {
                this.cleanupAfterCompletion(defStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback(TransactionStatus status) throws TransactionException {
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        try {
            try {
                this.triggerBeforeCompletion(defStatus, null);
                if (status.isNewTransaction()) {
                    this.logger.info((Object)"Initiating transaction rollback");
                    this.doRollback(defStatus);
                } else if (defStatus.getTransaction() != null) {
                    if (defStatus.isDebug()) {
                        this.logger.debug((Object)"Setting existing transaction rollback-only");
                    }
                    this.doSetRollbackOnly(defStatus);
                } else {
                    this.logger.info((Object)"Should roll back transaction but cannot - no transaction available");
                }
            }
            catch (RuntimeException ex) {
                this.triggerAfterCompletion(defStatus, 2, ex);
                throw ex;
            }
            catch (Error err) {
                this.triggerAfterCompletion(defStatus, 2, err);
                throw err;
            }
            this.triggerAfterCompletion(defStatus, 1, null);
        }
        finally {
            this.cleanupAfterCompletion(defStatus);
        }
    }

    private void doRollbackOnCommitException(DefaultTransactionStatus status, Throwable ex) throws TransactionException {
        try {
            if (status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug((Object)"Initiating transaction rollback on commit exception", ex);
                }
                this.doRollback(status);
            }
        }
        catch (RuntimeException rbex) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2, rbex);
            throw rbex;
        }
        catch (Error rberr) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2, rberr);
            throw rberr;
        }
        this.triggerAfterCompletion(status, 1, ex);
    }

    private void triggerBeforeCommit(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            this.logger.debug((Object)"Triggering beforeCommit synchronization");
            Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                synchronization.beforeCommit(status.isReadOnly());
            }
        }
    }

    private void triggerBeforeCompletion(DefaultTransactionStatus status, Throwable ex) {
        if (status.isNewSynchronization()) {
            this.logger.debug((Object)"Triggering beforeCompletion synchronization");
            try {
                Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
                while (it.hasNext()) {
                    TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                    synchronization.beforeCompletion();
                }
            }
            catch (RuntimeException tsex) {
                if (ex != null) {
                    this.logger.error((Object)"Rollback exception overridden by synchronization exception", ex);
                }
                throw tsex;
            }
            catch (Error tserr) {
                if (ex != null) {
                    this.logger.error((Object)"Rollback exception overridden by synchronization exception", ex);
                }
                throw tserr;
            }
        }
    }

    private void triggerAfterCompletion(DefaultTransactionStatus status, int completionStatus, Throwable ex) {
        if (status.isNewSynchronization()) {
            this.logger.debug((Object)"Triggering afterCompletion synchronization");
            try {
                Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
                while (it.hasNext()) {
                    TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                    synchronization.afterCompletion(completionStatus);
                }
            }
            catch (RuntimeException tsex) {
                if (ex != null) {
                    this.logger.error((Object)"Rollback exception overridden by synchronization exception", ex);
                }
                throw tsex;
            }
            catch (Error tserr) {
                if (ex != null) {
                    this.logger.error((Object)"Rollback exception overridden by synchronization exception", ex);
                }
                throw tserr;
            }
        }
    }

    private void cleanupAfterCompletion(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            TransactionSynchronizationManager.clearSynchronization();
        }
        if (status.isNewTransaction()) {
            this.doCleanupAfterCompletion(status.getTransaction());
        }
        if (status.getSuspendedResources() != null) {
            if (status.isDebug()) {
                this.logger.debug((Object)"Resuming suspended transaction");
            }
            this.resume(status.getTransaction(), status.getSuspendedResources());
        }
    }

    protected abstract Object doGetTransaction() throws TransactionException;

    protected abstract boolean isExistingTransaction(Object var1) throws TransactionException;

    protected abstract void doBegin(Object var1, TransactionDefinition var2) throws TransactionException;

    protected abstract Object doSuspend(Object var1) throws TransactionException;

    protected abstract void doResume(Object var1, Object var2) throws TransactionException;

    protected abstract boolean isRollbackOnly(Object var1) throws TransactionException;

    protected abstract void doCommit(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doRollback(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doSetRollbackOnly(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doCleanupAfterCompletion(Object var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SuspendedResourcesHolder {
        private final List suspendedSynchronizations;
        private final Object suspendedResources;

        private SuspendedResourcesHolder(List suspendedSynchronizations, Object suspendedResources) {
            this.suspendedSynchronizations = suspendedSynchronizations;
            this.suspendedResources = suspendedResources;
        }

        private List getSuspendedSynchronizations() {
            return this.suspendedSynchronizations;
        }

        private Object getSuspendedResources() {
            return this.suspendedResources;
        }
    }
}

