/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.CustomSQLErrorCodesTranslation;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodes;

public class SQLErrorCodesFactory {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$SQLErrorCodesFactory == null ? (class$org$springframework$jdbc$support$SQLErrorCodesFactory = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodesFactory")) : class$org$springframework$jdbc$support$SQLErrorCodesFactory));
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/springframework/jdbc/support/sql-error-codes.xml";
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map dataSourceProductName = new HashMap(10);
    private final Map rdbmsErrorCodes;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodesFactory;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodes;

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        HashMap<String, SQLErrorCodes> errorCodes = null;
        try {
            String path = SQL_ERROR_CODE_OVERRIDE_PATH;
            Resource resource = this.loadResource(path);
            if (!(resource != null && resource.exists() || (resource = this.loadResource(path = SQL_ERROR_CODE_DEFAULT_PATH)) != null && resource.exists())) {
                throw new BeanDefinitionStoreException("Unable to locate file [org/springframework/jdbc/support/sql-error-codes.xml]");
            }
            XmlBeanFactory bf = new XmlBeanFactory(resource);
            String[] rdbmsNames = bf.getBeanDefinitionNames(class$org$springframework$jdbc$support$SQLErrorCodes == null ? (class$org$springframework$jdbc$support$SQLErrorCodes = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodes")) : class$org$springframework$jdbc$support$SQLErrorCodes);
            errorCodes = new HashMap(rdbmsNames.length);
            for (int i = 0; i < rdbmsNames.length; ++i) {
                SQLErrorCodes ec = (SQLErrorCodes)bf.getBean(rdbmsNames[i]);
                if (ec.getBadSqlGrammarCodes() == null) {
                    ec.setBadSqlGrammarCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getBadSqlGrammarCodes());
                }
                if (ec.getDataIntegrityViolationCodes() == null) {
                    ec.setDataIntegrityViolationCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getDataIntegrityViolationCodes());
                }
                if (ec.getDataRetrievalFailureCodes() == null) {
                    ec.setDataRetrievalFailureCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getDataRetrievalFailureCodes());
                }
                if (ec.getOptimisticLockingFailureCodes() == null) {
                    ec.setOptimisticLockingFailureCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getOptimisticLockingFailureCodes());
                }
                if (ec.getCannotAcquireLockCodes() == null) {
                    ec.setCannotAcquireLockCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getCannotAcquireLockCodes());
                }
                if (ec.getDataAccessResourceFailureCodes() == null) {
                    ec.setDataAccessResourceFailureCodes(new String[0]);
                } else {
                    Arrays.sort(ec.getDataAccessResourceFailureCodes());
                }
                if (!ec.getCustomTranslations().isEmpty()) {
                    Iterator customIter = ec.getCustomTranslations().iterator();
                    while (customIter.hasNext()) {
                        CustomSQLErrorCodesTranslation customCode = (CustomSQLErrorCodesTranslation)customIter.next();
                        Arrays.sort(customCode.getErrorCodes());
                    }
                }
                if (ec.getDatabaseProductName() == null) {
                    errorCodes.put(rdbmsNames[i], ec);
                    continue;
                }
                errorCodes.put(ec.getDatabaseProductName(), ec);
            }
            logger.info((Object)("SQLErrorCodes loaded: " + errorCodes.keySet()));
        }
        catch (BeanDefinitionStoreException ex) {
            logger.warn((Object)("Error loading error codes from config file. Message: " + ex.getMessage()));
            errorCodes = new HashMap<String, SQLErrorCodes>(0);
        }
        this.rdbmsErrorCodes = errorCodes;
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path);
    }

    public SQLErrorCodes getErrorCodes(DataSource ds) {
        logger.info((Object)"Looking up default SQLErrorCodes for DataSource");
        String dataSourceDbName = (String)this.dataSourceProductName.get(ds);
        if (dataSourceDbName != null) {
            logger.info((Object)("Database product name found in cache for DataSource [" + ds + "]. Name is '" + dataSourceDbName + "'."));
            return this.getErrorCodes(dataSourceDbName);
        }
        try {
            Map dbmdInfo = (Map)JdbcUtils.extractDatabaseMetaData(ds, new DatabaseMetaDataCallback(){

                public Object processMetaData(DatabaseMetaData dbmd) throws SQLException {
                    HashMap<String, String> info = new HashMap<String, String>(2);
                    if (dbmd != null) {
                        info.put("DatabaseProductName", dbmd.getDatabaseProductName());
                        info.put("DriverVersion", dbmd.getDriverVersion());
                    }
                    return info;
                }
            });
            if (dbmdInfo != null) {
                String dbName = (String)dbmdInfo.get("DatabaseProductName");
                String driverVersion = (String)dbmdInfo.get("DriverVersion");
                if (dbName != null && dbName.startsWith("DB2")) {
                    dbName = "DB2";
                }
                Iterator dbNameIter = this.rdbmsErrorCodes.keySet().iterator();
                while (dbNameIter.hasNext()) {
                    String checkDbName = (String)dbNameIter.next();
                    if (checkDbName == null || !checkDbName.startsWith("*") && !checkDbName.endsWith("*") || dbName == null) continue;
                    if (checkDbName.startsWith("*") && checkDbName.endsWith("*")) {
                        if (dbName.indexOf(checkDbName.substring(1, checkDbName.length() - 1)) < 0) continue;
                        dbName = checkDbName;
                        continue;
                    }
                    if (checkDbName.startsWith("*")) {
                        if (!dbName.endsWith(checkDbName.substring(1, checkDbName.length()))) continue;
                        dbName = checkDbName;
                        continue;
                    }
                    if (!checkDbName.endsWith("*") || !dbName.startsWith(checkDbName.substring(0, checkDbName.length() - 1))) continue;
                    dbName = checkDbName;
                }
                if (dbName != null) {
                    this.dataSourceProductName.put(ds, dbName);
                    logger.info((Object)("Database Product Name is " + dbName));
                    logger.info((Object)("Driver Version is " + driverVersion));
                    SQLErrorCodes sec = (SQLErrorCodes)this.rdbmsErrorCodes.get(dbName);
                    if (sec != null) {
                        return sec;
                    }
                    logger.info((Object)("Error Codes for " + dbName + " not found"));
                }
            }
        }
        catch (MetaDataAccessException ex) {
            logger.warn((Object)"Error while getting database metadata", (Throwable)((Object)ex));
        }
        return new SQLErrorCodes();
    }

    public SQLErrorCodes getErrorCodes(String dbName) {
        SQLErrorCodes sec = (SQLErrorCodes)this.rdbmsErrorCodes.get(dbName);
        if (sec == null) {
            sec = new SQLErrorCodes();
        }
        return sec;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

