/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SingleConnectionDataSource
extends DriverManagerDataSource
implements SmartDataSource,
DisposableBean {
    private boolean suppressClose;
    private Boolean autoCommit;
    private Connection target;
    private Connection connection;
    private final Object connectionMonitor = new Object();
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$ConnectionProxy;

    public SingleConnectionDataSource() {
    }

    public SingleConnectionDataSource(String driverClassName, String url, String username, String password, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(driverClassName, url, username, password);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(String url, String username, String password, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(url, username, password);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(String url, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(url);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(Connection target, boolean suppressClose) {
        Assert.notNull((Object)target, (String)"Connection must not be null");
        this.target = target;
        this.suppressClose = suppressClose;
        this.connection = suppressClose ? this.getCloseSuppressingConnectionProxy(target) : target;
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    protected boolean isSuppressClose() {
        return this.suppressClose;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean getAutoCommitValue() {
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.initConnection();
            }
            if (this.connection.isClosed()) {
                throw new SQLException("Connection was closed in SingleConnectionDataSource. Check that user code checks shouldClose() before closing Connections, or set 'suppressClose' to 'true'");
            }
            return this.connection;
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (ObjectUtils.nullSafeEquals((Object)username, (Object)this.getUsername()) && ObjectUtils.nullSafeEquals((Object)password, (Object)this.getPassword())) {
            return this.getConnection();
        }
        throw new SQLException("SingleConnectionDataSource does not support custom username and password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldClose(Connection con) {
        Object object = this.connectionMonitor;
        synchronized (object) {
            return con != this.connection && con != this.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() throws SQLException {
        if (this.getUrl() == null) {
            throw new IllegalStateException("'url' property is required for lazily initializing a Connection");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
            this.target = this.getConnectionFromDriverManager();
            this.prepareConnection(this.target);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Established shared JDBC Connection: " + this.target));
            }
            this.connection = this.isSuppressClose() ? this.getCloseSuppressingConnectionProxy(this.target) : this.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
            this.target = null;
            this.connection = null;
        }
    }

    protected void prepareConnection(Connection con) throws SQLException {
        Boolean autoCommit = this.getAutoCommitValue();
        if (autoCommit != null && con.getAutoCommit() != autoCommit.booleanValue()) {
            con.setAutoCommit(autoCommit);
        }
    }

    private void closeConnection() {
        if (this.target != null) {
            try {
                this.target.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not close shared JDBC Connection", ex);
            }
        }
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance((class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = SingleConnectionDataSource.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy).getClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = SingleConnectionDataSource.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

