/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DelegatingDataSource
implements DataSource,
InitializingBean {
    private DataSource targetDataSource;

    public DelegatingDataSource() {
    }

    public DelegatingDataSource(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
    }

    public final void setTargetDataSource(DataSource targetDataSource) {
        Assert.notNull((Object)targetDataSource, (String)"targetDataSource must not be null");
        this.targetDataSource = targetDataSource;
    }

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    public void afterPropertiesSet() {
        if (this.getTargetDataSource() == null) {
            throw new IllegalArgumentException("targetDataSource is required");
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getTargetDataSource().getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getTargetDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getTargetDataSource().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getTargetDataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getTargetDataSource().setLoginTimeout(seconds);
    }
}

