/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.naming;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.aop.support.AopUtils;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.StringUtils;

public class MetadataNamingStrategy
implements ObjectNamingStrategy {
    private JmxAttributeSource attributeSource;

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        this.attributeSource = attributeSource;
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        if (AopUtils.isJdkDynamicProxy((Object)managedBean)) {
            throw new IllegalArgumentException("MetadataNamingStrategy does not support JDK dynamic proxies - export the target beans directly or use CGLIB proxies instead");
        }
        Class managedClass = JmxUtils.getClassToExpose(managedBean);
        ManagedResource mr = this.attributeSource.getManagedResource(managedClass);
        if (mr == null) {
            throw new MalformedObjectNameException("Your bean class [" + managedBean.getClass().getName() + "] must be marked with a valid ManagedResource attribute when using MetadataNamingStrategy");
        }
        String objectName = mr.getObjectName();
        if (!StringUtils.hasText((String)objectName)) {
            throw new MalformedObjectNameException("You must specify an ObjectName for class [" + managedBean.getClass().getName() + "]");
        }
        return ObjectNameManager.getInstance(objectName);
    }
}

