/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import reactor.core.composable.Promise;
import reactor.function.Consumer;

public abstract class AbstractPromiseToListenableFutureAdapter<S, T>
implements ListenableFuture<T> {
    private final Promise<S> promise;
    private final ListenableFutureCallbackRegistry<T> registry = new ListenableFutureCallbackRegistry();

    protected AbstractPromiseToListenableFutureAdapter(Promise<S> promise) {
        Assert.notNull(promise, (String)"Promise must not be null");
        this.promise = promise;
        this.promise.onSuccess(new Consumer<S>(){

            public void accept(S result) {
                try {
                    AbstractPromiseToListenableFutureAdapter.this.registry.success(AbstractPromiseToListenableFutureAdapter.this.adapt(result));
                }
                catch (Throwable t) {
                    AbstractPromiseToListenableFutureAdapter.this.registry.failure(t);
                }
            }
        });
        this.promise.onError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable t) {
                AbstractPromiseToListenableFutureAdapter.this.registry.failure(t);
            }
        });
    }

    protected abstract T adapt(S var1);

    public T get() throws InterruptedException {
        Object result = this.promise.await();
        return this.adapt(result);
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.promise.await(timeout, unit);
        if (result == null) {
            throw new TimeoutException();
        }
        return this.adapt(result);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.promise.isComplete();
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.registry.addCallback(callback);
    }
}

