/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.AbstractSpringContextTests;

public abstract class AbstractDependencyInjectionSpringContextTests
extends AbstractSpringContextTests {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    private boolean populateProtectedVariables = false;
    private int autowireMode = 2;
    private boolean dependencyCheck = true;
    protected ConfigurableApplicationContext applicationContext;
    protected String[] managedVariableNames;
    private int loadCount = 0;
    static /* synthetic */ Class class$org$springframework$test$AbstractDependencyInjectionSpringContextTests;
    static /* synthetic */ Class class$org$springframework$test$AbstractSpringContextTests;

    public AbstractDependencyInjectionSpringContextTests() {
    }

    public AbstractDependencyInjectionSpringContextTests(String name) {
        super(name);
    }

    public void setPopulateProtectedVariables(boolean populateFields) {
        this.populateProtectedVariables = populateFields;
    }

    public boolean isPopulateProtectedVariables() {
        return this.populateProtectedVariables;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    public final int getLoadCount() {
        return this.loadCount;
    }

    public void setDirty() {
        this.setDirty(this.getConfigLocations());
    }

    protected final void setUp() throws Exception {
        this.applicationContext = this.getContext(this.contextKey());
        this.injectDependencies();
        try {
            this.onSetUp();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Setup error", (Throwable)ex);
            throw ex;
        }
    }

    protected void injectDependencies() throws Exception {
        if (this.isPopulateProtectedVariables()) {
            if (this.managedVariableNames == null) {
                this.initManagedVariableNames();
            }
            this.populateProtectedVariables();
        } else if (this.getAutowireMode() != 0) {
            this.applicationContext.getBeanFactory().autowireBeanProperties((Object)this, this.getAutowireMode(), this.isDependencyCheck());
        }
    }

    protected Object contextKey() {
        return this.getConfigLocations();
    }

    protected ConfigurableApplicationContext loadContextLocations(String[] locations) {
        ++this.loadCount;
        return super.loadContextLocations(locations);
    }

    protected void initManagedVariableNames() throws IllegalAccessException {
        LinkedList<String> managedVarNames = new LinkedList<String>();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        do {
            Field[] fields = clazz.getDeclaredFields();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + fields.length + " fields on " + clazz));
            }
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Candidate field: " + field));
                }
                if (!AbstractDependencyInjectionSpringContextTests.isProtectedInstanceField(field)) continue;
                Object oldValue = field.get((Object)this);
                if (oldValue == null) {
                    managedVarNames.add(field.getName());
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Added managed variable '" + field.getName() + "'"));
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Rejected managed variable '" + field.getName() + "'"));
            }
        } while (!(clazz = clazz.getSuperclass()).equals(class$org$springframework$test$AbstractDependencyInjectionSpringContextTests == null ? AbstractDependencyInjectionSpringContextTests.class$("org.springframework.test.AbstractDependencyInjectionSpringContextTests") : class$org$springframework$test$AbstractDependencyInjectionSpringContextTests));
        this.managedVariableNames = managedVarNames.toArray(new String[managedVarNames.size()]);
    }

    private static boolean isProtectedInstanceField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && Modifier.isProtected(modifiers);
    }

    protected void populateProtectedVariables() throws IllegalAccessException {
        for (int i = 0; i < this.managedVariableNames.length; ++i) {
            String varName = this.managedVariableNames[i];
            Object bean = null;
            try {
                Field field = this.findField(((Object)((Object)this)).getClass(), varName);
                bean = this.applicationContext.getBean(varName, field.getType());
                field.setAccessible(true);
                field.set((Object)this, bean);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Populated field: " + field));
                continue;
            }
            catch (NoSuchFieldException ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("No field with name '" + varName + "'"));
                continue;
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("No bean with name '" + varName + "'"));
            }
        }
    }

    private Field findField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = clazz.getSuperclass();
            if (superclass != (class$org$springframework$test$AbstractSpringContextTests == null ? (class$org$springframework$test$AbstractSpringContextTests = AbstractDependencyInjectionSpringContextTests.class$("org.springframework.test.AbstractSpringContextTests")) : class$org$springframework$test$AbstractSpringContextTests)) {
                return this.findField(superclass, name);
            }
            throw ex;
        }
    }

    protected void onSetUp() throws Exception {
    }

    protected final void tearDown() {
        try {
            this.onTearDown();
        }
        catch (Exception ex) {
            this.logger.error((Object)"onTearDown error", (Throwable)ex);
        }
    }

    protected void onTearDown() throws Exception {
    }

    protected abstract String[] getConfigLocations();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

