/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import junit.framework.Assert;

public abstract class AssertThrows {
    private Class expectedException;
    private String failureMessage;
    static /* synthetic */ Class class$java$lang$Exception;

    public AssertThrows(Class expectedException) {
        this(expectedException, null);
    }

    public AssertThrows(Class expectedException, String failureMessage) {
        if (expectedException == null) {
            throw new IllegalArgumentException("The 'expectedException' argument is required.");
        }
        if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = AssertThrows.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(expectedException)) {
            throw new IllegalArgumentException("The 'expectedException' argument is not an Exception type (it obviously must be).");
        }
        this.expectedException = expectedException;
        this.failureMessage = failureMessage;
    }

    protected Class getExpectedException() {
        return this.expectedException;
    }

    protected String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public abstract void test() throws Exception;

    public void runTest() {
        try {
            this.test();
            this.doFail();
        }
        catch (Exception actualException) {
            this.checkExceptionExpectations(actualException);
        }
    }

    protected void doFail() {
        Assert.fail((String)this.createMessageForNoExceptionThrown());
    }

    protected String createMessageForNoExceptionThrown() {
        StringBuffer buffer = new StringBuffer("Must have thrown a [").append(this.getExpectedException()).append("]");
        if (this.getFailureMessage() != null) {
            buffer.append(" : ").append(this.getFailureMessage()).append(".");
        }
        return buffer.toString();
    }

    protected void checkExceptionExpectations(Exception actualException) {
        Class<?> actualExceptionType = actualException.getClass();
        Assert.assertTrue((String)this.createMessageForWrongThrownExceptionType(actualException), (boolean)this.getExpectedException().isAssignableFrom(actualExceptionType));
    }

    protected String createMessageForWrongThrownExceptionType(Exception actualException) {
        StringBuffer buffer = new StringBuffer().append("Was expecting a [").append(this.getExpectedException()).append("] to be thrown, but instead a [").append(actualException.getClass()).append("] was thrown.");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

