/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractTransactionalSpringContextTests
extends AbstractDependencyInjectionSpringContextTests {
    protected PlatformTransactionManager transactionManager;
    private boolean defaultRollback = true;
    private boolean complete = false;
    private int transactionsStarted = 0;
    protected TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    protected TransactionStatus transactionStatus;

    public AbstractTransactionalSpringContextTests() {
    }

    public AbstractTransactionalSpringContextTests(String name) {
        super(name);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setDefaultRollback(boolean defaultRollback) {
        this.defaultRollback = defaultRollback;
    }

    protected void preventTransaction() {
        this.transactionDefinition = null;
    }

    protected void setTransactionDefinition(TransactionDefinition customDefinition) {
        this.transactionDefinition = customDefinition;
    }

    protected final void onSetUp() throws Exception {
        boolean bl = this.complete = !this.defaultRollback;
        if (this.transactionManager == null) {
            this.logger.info((Object)"No transaction manager set: test will NOT run within a transaction");
        } else if (this.transactionDefinition == null) {
            this.logger.info((Object)"No transaction definition set: test will NOT run within a transaction");
        } else {
            this.onSetUpBeforeTransaction();
            this.startNewTransaction();
            try {
                this.onSetUpInTransaction();
            }
            catch (Exception ex) {
                this.endTransaction();
                throw ex;
            }
        }
    }

    protected void onSetUpBeforeTransaction() throws Exception {
    }

    protected void onSetUpInTransaction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onTearDown() throws Exception {
        if (this.transactionStatus != null && !this.transactionStatus.isCompleted()) {
            try {
                this.onTearDownInTransaction();
            }
            finally {
                this.endTransaction();
            }
        }
        if (this.transactionsStarted > 0) {
            this.onTearDownAfterTransaction();
        }
    }

    protected void onTearDownInTransaction() throws Exception {
    }

    protected void onTearDownAfterTransaction() throws Exception {
    }

    protected void setComplete() {
        if (this.transactionManager == null) {
            throw new IllegalStateException("No transaction manager set");
        }
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction() {
        if (this.transactionStatus != null) {
            try {
                if (!this.complete) {
                    this.transactionManager.rollback(this.transactionStatus);
                    this.logger.info((Object)"Rolled back transaction after test execution");
                } else {
                    this.transactionManager.commit(this.transactionStatus);
                    this.logger.info((Object)"Committed transaction after test execution");
                }
            }
            finally {
                this.transactionStatus = null;
            }
        }
    }

    protected void startNewTransaction() throws TransactionException {
        if (this.transactionStatus != null) {
            throw new IllegalStateException("Cannot start new transaction without ending existing transaction: Invoke endTransaction() before startNewTransaction()");
        }
        if (this.transactionManager == null) {
            throw new IllegalStateException("No transaction manager set");
        }
        this.transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        ++this.transactionsStarted;
        boolean bl = this.complete = !this.defaultRollback;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Began transaction (" + this.transactionsStarted + "): transaction manager [" + this.transactionManager + "]; default rollback = " + this.defaultRollback));
        }
    }
}

