/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class LocalPersistenceManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Method getPersistenceManagerFactoryMethod = ClassUtils.getMethodIfAvailable((Class)(class$javax$jdo$JDOHelper == null ? (class$javax$jdo$JDOHelper = LocalPersistenceManagerFactoryBean.class$("javax.jdo.JDOHelper")) : class$javax$jdo$JDOHelper), (String)"getPersistenceManagerFactory", (Class[])new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = LocalPersistenceManagerFactoryBean.class$("java.util.Properties")) : class$java$util$Properties});
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Properties jdoProperties;
    private PersistenceManagerFactory persistenceManagerFactory;
    static /* synthetic */ Class class$javax$jdo$JDOHelper;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setJdoProperties(Properties jdoProperties) {
        this.jdoProperties = jdoProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IllegalArgumentException, IOException, JDOException {
        if (this.configLocation == null && this.jdoProperties == null) {
            throw new IllegalArgumentException("Either configLocation or jdoProperties must be set");
        }
        Properties props = new Properties();
        if (this.configLocation != null) {
            InputStream is = this.configLocation.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        if (this.jdoProperties != null) {
            Enumeration<?> en = this.jdoProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                props.setProperty(key, this.jdoProperties.getProperty(key));
            }
        }
        this.logger.info((Object)"Building new JDO PersistenceManagerFactory");
        this.persistenceManagerFactory = this.newPersistenceManagerFactory(props);
    }

    protected PersistenceManagerFactory newPersistenceManagerFactory(Properties props) {
        if (getPersistenceManagerFactoryMethod != null) {
            return (PersistenceManagerFactory)ReflectionUtils.invokeMethod((Method)getPersistenceManagerFactoryMethod, null, (Object[])new Object[]{props});
        }
        return JDOHelper.getPersistenceManagerFactory((Map)props);
    }

    public Object getObject() {
        return this.persistenceManagerFactory;
    }

    public Class getObjectType() {
        return this.persistenceManagerFactory != null ? this.persistenceManagerFactory.getClass() : (class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = LocalPersistenceManagerFactoryBean.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Closing JDO PersistenceManagerFactory");
        this.persistenceManagerFactory.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

