/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ojb;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.ojb.OjbFactoryUtils;
import org.springframework.orm.ojb.PersistenceBrokerHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PersistenceBrokerTransactionManager
extends AbstractPlatformTransactionManager {
    private PBKey pbKey = PersistenceBrokerFactory.getDefaultKey();
    private DataSource dataSource;

    public PersistenceBrokerTransactionManager() {
    }

    public PersistenceBrokerTransactionManager(String jcdAlias) {
        this.setJcdAlias(jcdAlias);
    }

    public PersistenceBrokerTransactionManager(PBKey pbKey) {
        this.setPbKey(pbKey);
    }

    public void setJcdAlias(String jcdAlias) {
        this.pbKey = new PBKey(jcdAlias);
    }

    public void setPbKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public PBKey getPbKey() {
        return this.pbKey;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected Object doGetTransaction() {
        PersistenceBrokerTransactionObject txObject = new PersistenceBrokerTransactionObject();
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getPbKey()));
        txObject.setPersistenceBrokerHolder(pbHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)transaction);
        return txObject.getPersistenceBrokerHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource((Object)this.getDataSource())) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! PersistenceBrokerTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single PersistenceBrokerTransactionManager for all transactions on a single DataSource, no matter whether PersistenceBroker or JDBC access.");
        }
        PersistenceBroker pb = null;
        try {
            pb = this.getPersistenceBroker();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Opened new PersistenceBroker [" + pb + "] for OJB transaction"));
            }
            PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)transaction);
            txObject.setPersistenceBrokerHolder(new PersistenceBrokerHolder(pb));
            Connection con = pb.serviceConnectionManager().getConnection();
            Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
            txObject.setPreviousIsolationLevel(previousIsolationLevel);
            pb.beginTransaction();
            if (this.getDataSource() != null) {
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (definition.getTimeout() != -1) {
                    conHolder.setTimeoutInSeconds(definition.getTimeout());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing OJB transaction as JDBC transaction [" + conHolder.getConnection() + "]"));
                }
                TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            TransactionSynchronizationManager.bindResource((Object)this.getPbKey(), (Object)((Object)txObject.getPersistenceBrokerHolder()));
        }
        catch (Exception ex) {
            this.releasePersistenceBroker(pb);
            throw new CannotCreateTransactionException("Could not open OJB PersistenceBroker for transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)transaction);
        txObject.setPersistenceBrokerHolder(null);
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getPbKey()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(pbHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.getPbKey())) {
            TransactionSynchronizationManager.unbindResource((Object)this.getPbKey());
        }
        TransactionSynchronizationManager.bindResource((Object)this.getPbKey(), (Object)((Object)resourcesHolder.getPersistenceBrokerHolder()));
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing OJB transaction on PersistenceBroker [" + txObject.getPersistenceBrokerHolder().getPersistenceBroker() + "]"));
        }
        try {
            txObject.getPersistenceBrokerHolder().getPersistenceBroker().commitTransaction();
        }
        catch (TransactionAbortedException ex) {
            throw new TransactionSystemException("Could not commit OJB transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back OJB transaction on PersistenceBroker [" + txObject.getPersistenceBrokerHolder().getPersistenceBroker() + "]"));
        }
        txObject.getPersistenceBrokerHolder().getPersistenceBroker().abortTransaction();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting OJB transaction on PersistenceBroker [" + txObject.getPersistenceBrokerHolder().getPersistenceBroker() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)((Object)transaction);
        TransactionSynchronizationManager.unbindResource((Object)this.getPbKey());
        txObject.getPersistenceBrokerHolder().clear();
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        PersistenceBroker pb = txObject.getPersistenceBrokerHolder().getPersistenceBroker();
        try {
            Connection con = pb.serviceConnectionManager().getConnection();
            DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)txObject.getPreviousIsolationLevel());
        }
        catch (LookupException ex) {
            this.logger.info((Object)"Could not look up JDBC Connection of OJB PersistenceBroker", (Throwable)ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing OJB PersistenceBroker [" + pb + "] after transaction"));
        }
        this.releasePersistenceBroker(pb);
    }

    protected PersistenceBroker getPersistenceBroker() throws OJBRuntimeException {
        return PersistenceBrokerFactory.createPersistenceBroker((PBKey)this.getPbKey());
    }

    protected void releasePersistenceBroker(PersistenceBroker pb) {
        OjbFactoryUtils.releasePersistenceBroker(pb, this.getPbKey());
    }

    private static class SuspendedResourcesHolder {
        private final PersistenceBrokerHolder persistenceBrokerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(PersistenceBrokerHolder pbHolder, ConnectionHolder conHolder) {
            this.persistenceBrokerHolder = pbHolder;
            this.connectionHolder = conHolder;
        }

        private PersistenceBrokerHolder getPersistenceBrokerHolder() {
            return this.persistenceBrokerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private static class PersistenceBrokerTransactionObject
    extends JdbcTransactionObjectSupport {
        private PersistenceBrokerHolder persistenceBrokerHolder;

        private PersistenceBrokerTransactionObject() {
        }

        public void setPersistenceBrokerHolder(PersistenceBrokerHolder persistenceBrokerHolder) {
            this.persistenceBrokerHolder = persistenceBrokerHolder;
        }

        public PersistenceBrokerHolder getPersistenceBrokerHolder() {
            return this.persistenceBrokerHolder;
        }

        public void setRollbackOnly() {
            this.getPersistenceBrokerHolder().setRollbackOnly();
            if (this.getConnectionHolder() != null) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.getPersistenceBrokerHolder().isRollbackOnly() || this.getConnectionHolder() != null && this.getConnectionHolder().isRollbackOnly();
        }
    }
}

