/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionHolder;
import org.springframework.orm.toplink.TopLinkJdbcException;
import org.springframework.orm.toplink.TopLinkOptimisticLockingFailureException;
import org.springframework.orm.toplink.TopLinkQueryException;
import org.springframework.orm.toplink.TopLinkSystemException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class SessionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$toplink$SessionFactoryUtils == null ? (class$org$springframework$orm$toplink$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.toplink.SessionFactoryUtils")) : class$org$springframework$orm$toplink$SessionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$toplink$SessionFactoryUtils;

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, allowCreate);
        }
        catch (TopLinkException ex) {
            throw new DataAccessResourceFailureException("Could not open TopLink Session", (Throwable)ex);
        }
    }

    public static Session doGetSession(SessionFactory sessionFactory, boolean allowCreate) throws TopLinkException, IllegalStateException {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null) {
            return sessionHolder.getSession();
        }
        if (!allowCreate && !TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("No TopLink Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        logger.debug((Object)"Creating TopLink Session");
        Session session = sessionFactory.createSession();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering new Spring transaction synchronization for new TopLink Session");
            sessionHolder = new SessionHolder(session);
            sessionHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, sessionFactory));
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
        }
        return session;
    }

    public static boolean isSessionTransactional(Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && session == sessionHolder.getSession();
    }

    public static DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        if (ex instanceof DatabaseException) {
            return new TopLinkJdbcException((DatabaseException)ex);
        }
        if (ex instanceof OptimisticLockException) {
            return new TopLinkOptimisticLockingFailureException((OptimisticLockException)ex);
        }
        if (ex instanceof QueryException) {
            return new TopLinkQueryException((QueryException)ex);
        }
        if (ex instanceof ConcurrencyException) {
            return new ConcurrencyFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ConversionException) {
            return new TypeMismatchDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        return new TopLinkSystemException(ex);
    }

    public static void releaseSession(Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SessionFactoryUtils.doRelease(session);
        }
    }

    private static void doRelease(Session session) {
        if (session != null) {
            logger.debug((Object)"Closing TopLink Session");
            try {
                session.release();
            }
            catch (TopLinkException ex) {
                logger.debug((Object)"Could not close TopLink Session", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing TopLink Session", ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private boolean holderActive = true;

        private SessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory) {
            this.sessionHolder = sessionHolder;
            this.sessionFactory = sessionFactory;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.holderActive = false;
        }

        public void afterCompletion(int status) {
            SessionFactoryUtils.releaseSession(this.sessionHolder.getSession(), this.sessionFactory);
        }
    }
}

