/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.service.UnknownServiceException;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.hibernate.SessionHolder;
import org.springframework.orm.jpa.hibernate.SpringFlushSynchronization;
import org.springframework.orm.jpa.hibernate.SpringJtaSessionContext;
import org.springframework.orm.jpa.hibernate.SpringSessionSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor sessionFactory;
    private @Nullable TransactionManager transactionManager;
    private @Nullable CurrentSessionContext jtaSessionContext;

    public SpringSessionContext(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        try {
            JtaPlatform jtaPlatform = (JtaPlatform)sessionFactory.getServiceRegistry().requireService(JtaPlatform.class);
            this.transactionManager = jtaPlatform.retrieveTransactionManager();
            if (this.transactionManager != null) {
                this.jtaSessionContext = new SpringJtaSessionContext(sessionFactory);
            }
        }
        catch (Exception ex) {
            LogFactory.getLog(SpringSessionContext.class).warn((Object)"Could not introspect Hibernate JtaPlatform for SpringJtaSessionContext", (Throwable)ex);
        }
    }

    public Session currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        SessionHolder holder = null;
        if (value instanceof Session) {
            Session session = (Session)value;
            return session;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)((Object)value);
            if (sessionHolder.hasSession()) {
                Session session = sessionHolder.getSession();
                if (!sessionHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                    FlushMode flushMode = session.getHibernateFlushMode();
                    if (flushMode.equals((Object)FlushMode.MANUAL) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                        session.setHibernateFlushMode(FlushMode.AUTO);
                        sessionHolder.setPreviousFlushMode(flushMode);
                    }
                }
                return session;
            }
            holder = sessionHolder;
        } else if (value instanceof EntityManagerHolder) {
            EntityManagerHolder entityManagerHolder = (EntityManagerHolder)((Object)value);
            return (Session)entityManagerHolder.getEntityManager().unwrap(Session.class);
        }
        if (this.transactionManager != null && this.jtaSessionContext != null) {
            try {
                if (this.transactionManager.getStatus() == 0) {
                    Session session = this.jtaSessionContext.currentSession();
                    if (TransactionSynchronizationManager.isSynchronizationActive()) {
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringFlushSynchronization(session));
                    }
                    return session;
                }
            }
            catch (SystemException ex) {
                throw new HibernateException("JTA TransactionManager found but status check failed", (Throwable)ex);
            }
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            DataSource dataSource = SpringSessionContext.determineDataSource((SessionFactory)this.sessionFactory);
            Object session = dataSource != null ? this.sessionFactory.withOptions().connection(DataSourceUtils.getConnection((DataSource)dataSource)).openSession() : this.sessionFactory.openSession();
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
            }
            if (holder != null) {
                holder.setSession((Session)session);
            } else {
                SpringSessionContext.bindSessionHolder((SessionFactory)this.sessionFactory, new SessionHolder((Session)session));
            }
            return session;
        }
        throw new HibernateException("Could not obtain transaction-synchronized Session for current thread");
    }

    public static StatelessSession currentStatelessSession(SessionFactory sessionFactory) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new HibernateException("Could not obtain transaction-synchronized Session for current thread");
        }
        Object value = TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (value instanceof StatelessSession) {
            StatelessSession statelessSession = (StatelessSession)value;
            return statelessSession;
        }
        SessionHolder holder = null;
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)((Object)value);
            if (sessionHolder.hasStatelessSession()) {
                return sessionHolder.getStatelessSession();
            }
            holder = sessionHolder;
        }
        StatelessSession session = sessionFactory.openStatelessSession(SpringSessionContext.determineConnection(sessionFactory, holder));
        if (holder != null) {
            holder.setStatelessSession(session);
        } else {
            SpringSessionContext.bindSessionHolder(sessionFactory, new SessionHolder(session));
        }
        return session;
    }

    private static void bindSessionHolder(SessionFactory sessionFactory, SessionHolder holder) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(holder, sessionFactory, true));
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holder));
        holder.setSynchronizedWithTransaction(true);
    }

    private static Connection determineConnection(SessionFactory sessionFactory, @Nullable SessionHolder holder) {
        Session session;
        if (holder != null && (session = holder.getSession()) instanceof SessionImplementor) {
            SessionImplementor session2 = (SessionImplementor)session;
            return session2.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
        }
        DataSource dataSource = SpringSessionContext.determineDataSource(sessionFactory);
        if (dataSource != null) {
            return DataSourceUtils.getConnection((DataSource)dataSource);
        }
        throw new IllegalStateException("Cannot determine JDBC DataSource for Hibernate SessionFactory: " + String.valueOf(sessionFactory));
    }

    static @Nullable DataSource determineDataSource(SessionFactory sessionFactory) {
        Object dataSourceValue;
        Map props = sessionFactory.getProperties();
        if (props != null && (dataSourceValue = props.get("jakarta.persistence.nonJtaDataSource")) instanceof DataSource) {
            DataSource dataSourceToUse = (DataSource)dataSourceValue;
            return dataSourceToUse;
        }
        if (sessionFactory instanceof SessionFactoryImplementor) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            try {
                ConnectionProvider cp = (ConnectionProvider)sfi.getServiceRegistry().getService(ConnectionProvider.class);
                if (cp != null) {
                    return (DataSource)cp.unwrap(DataSource.class);
                }
            }
            catch (UnknownServiceException unknownServiceException) {
                // empty catch block
            }
        }
        return null;
    }
}

