/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.springframework.util.Assert;
import org.springframework.web.context.scope.RequestAttributes;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletRequestAttributes
implements RequestAttributes {
    private final PortletRequest request;
    private final Map sessionAttributesToUpdate = new HashMap();
    private final Map globalSessionAttributesToUpdate = new HashMap();

    public PortletRequestAttributes(PortletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.request = request;
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            return this.request.getAttribute(name);
        }
        PortletSession session = this.request.getPortletSession(false);
        if (session != null) {
            if (scope == 2) {
                Object value = session.getAttribute(name, 1);
                if (value != null) {
                    this.globalSessionAttributesToUpdate.put(name, value);
                }
                return value;
            }
            Object value = session.getAttribute(name);
            if (value != null) {
                this.sessionAttributesToUpdate.put(name, value);
            }
            return value;
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            this.request.setAttribute(name, value);
        } else {
            PortletSession session = this.request.getPortletSession(true);
            if (scope == 2) {
                session.setAttribute(name, value, 1);
                this.globalSessionAttributesToUpdate.remove(name);
            } else {
                session.setAttribute(name, value);
                this.sessionAttributesToUpdate.remove(name);
            }
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            this.request.removeAttribute(name);
        } else {
            PortletSession session = this.request.getPortletSession(false);
            if (session != null) {
                if (scope == 2) {
                    session.removeAttribute(name, 1);
                    this.globalSessionAttributesToUpdate.remove(name);
                } else {
                    session.removeAttribute(name);
                    this.sessionAttributesToUpdate.remove(name);
                }
            }
        }
    }

    public Object getSessionMutex() {
        return PortletUtils.getSessionMutex(this.request.getPortletSession());
    }

    public void updateAccessedAttributes() {
        PortletSession session = this.request.getPortletSession(false);
        if (session != null) {
            Object oldValue;
            Object newValue;
            String name;
            Map.Entry entry;
            Iterator it = this.sessionAttributesToUpdate.keySet().iterator();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                name = (String)entry.getKey();
                newValue = entry.getValue();
                oldValue = session.getAttribute(name);
                if (oldValue != newValue) continue;
                session.setAttribute(name, newValue);
            }
            it = this.globalSessionAttributesToUpdate.keySet().iterator();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                name = (String)entry.getKey();
                newValue = entry.getValue();
                oldValue = session.getAttribute(name, 1);
                if (oldValue != newValue) continue;
                session.setAttribute(name, newValue, 1);
            }
        }
        this.sessionAttributesToUpdate.clear();
        this.globalSessionAttributesToUpdate.clear();
    }
}

