/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Arrays;
import java.util.Enumeration;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.web.portlet.context.PortletApplicationObjectSupport;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;

public abstract class PortletContentGenerator
extends PortletApplicationObjectSupport {
    private boolean requireSession = false;
    private int cacheSeconds = -1;

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    protected final void checkAndPrepare(PortletRequest request, PortletResponse response) throws PortletException {
        this.checkAndPrepare(request, response, this.cacheSeconds);
    }

    protected final void checkAndPrepare(PortletRequest request, PortletResponse response, int cacheSeconds) throws PortletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checking and preparing " + (request instanceof RenderRequest ? "RenderRequest" : "ActionRequest")));
            Enumeration params = request.getParameterNames();
            if (params.hasMoreElements()) {
                this.logger.debug((Object)"Request Parameters:");
            }
            while (params.hasMoreElements()) {
                String paramName = (String)params.nextElement();
                String[] paramValues = request.getParameterValues(paramName);
                this.logger.debug((Object)("-- '" + paramName + "' = " + (paramValues == null ? "NULL" : Arrays.asList(paramValues).toString())));
            }
        }
        if (this.requireSession && request.getPortletSession(false) == null) {
            throw new PortletSessionRequiredException("Pre-existing session required but none found");
        }
        if (response instanceof RenderResponse) {
            this.applyCacheSeconds((RenderResponse)response, cacheSeconds);
        }
    }

    protected final void preventCaching(RenderResponse response) {
        this.cacheForSeconds(response, 0);
    }

    protected final void cacheForSeconds(RenderResponse response, int seconds) {
        response.setProperty("portlet.expiration-cache", new Integer(seconds).toString());
    }

    protected final void applyCacheSeconds(RenderResponse response, int seconds) {
        if (seconds > 0) {
            this.cacheForSeconds(response, seconds);
        } else if (seconds == 0) {
            this.preventCaching(response);
        }
    }
}

