/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.caucho.CauchoRemoteAccessor;

public class HessianClientInterceptor
extends CauchoRemoteAccessor
implements MethodInterceptor {
    private HessianProxyFactory proxyFactory;
    private Object hessianProxy;

    public void setProxyFactory(HessianProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void prepare() throws MalformedURLException {
        super.prepare();
        if (this.proxyFactory == null) {
            this.proxyFactory = new HessianProxyFactory();
        }
        if (this.getUsername() != null) {
            this.proxyFactory.setUser(this.getUsername());
        }
        if (this.getPassword() != null) {
            this.proxyFactory.setPassword(this.getPassword());
        }
        if (this.isOverloadEnabled()) {
            this.proxyFactory.setOverloadEnabled(this.isOverloadEnabled());
        }
        this.hessianProxy = this.createHessianProxy(this.proxyFactory);
    }

    protected Object createHessianProxy(HessianProxyFactory proxyFactory) throws MalformedURLException {
        return proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.hessianProxy == null) {
            throw new IllegalStateException("HessianClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.hessianProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof HessianRuntimeException) {
                HessianRuntimeException hre = (HessianRuntimeException)ex.getTargetException();
                Object rootCause = hre.getRootCause() != null ? hre.getRootCause() : hre;
                throw this.convertHessianAccessException((Throwable)rootCause);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw this.convertHessianAccessException(utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Failed to invoke Hessian proxy for remote service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteAccessException convertHessianAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to Hessian remote service at [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access Hessian remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

