/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.LocalTransactionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jca.cci.connection.ConnectionFactoryUtils;
import org.springframework.jca.cci.connection.ConnectionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CciLocalTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private ConnectionFactory connectionFactory;

    public CciLocalTransactionManager() {
    }

    public CciLocalTransactionManager(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void afterPropertiesSet() {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory is required");
        }
    }

    protected Object doGetTransaction() {
        CciLocalTransactionObject txObject = new CciLocalTransactionObject();
        ConnectionHolder conHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
        txObject.setConnectionHolder(conHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        return txObject.getConnectionHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        Connection con = null;
        try {
            con = this.getConnectionFactory().getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Acquired Connection [" + con + "] for local CCI transaction"));
            }
            txObject.setConnectionHolder(new ConnectionHolder(con));
            txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
            con.getLocalTransaction().begin();
            if (definition.getTimeout() != -1) {
                txObject.getConnectionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)txObject.getConnectionHolder()));
        }
        catch (NotSupportedException ex) {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
            throw new CannotCreateTransactionException("CCI Connection does not support local transactions", (Throwable)ex);
        }
        catch (LocalTransactionException ex) {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
            throw new CannotCreateTransactionException("Could not begin local CCI transaction", (Throwable)ex);
        }
        catch (ResourceException ex) {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
            throw new TransactionSystemException("Unexpected failure on begin of CCI local transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        txObject.setConnectionHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        ConnectionHolder conHolder = (ConnectionHolder)((Object)suspendedResources);
        TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)conHolder));
    }

    protected boolean isRollbackOnly(Object transaction) throws TransactionException {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        return txObject.getConnectionHolder().isRollbackOnly();
    }

    protected void doCommit(DefaultTransactionStatus status) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)status.getTransaction();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing CCI local transaction on Connection [" + con + "]"));
        }
        try {
            con.getLocalTransaction().commit();
        }
        catch (LocalTransactionException ex) {
            throw new TransactionSystemException("Could not commit CCI local transaction", (Throwable)ex);
        }
        catch (ResourceException ex) {
            throw new TransactionSystemException("Unexpected failure on commit of CCI local transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)status.getTransaction();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back CCI local transaction on Connection [" + con + "]"));
        }
        try {
            con.getLocalTransaction().rollback();
        }
        catch (LocalTransactionException ex) {
            throw new TransactionSystemException("Could not roll back CCI local transaction", (Throwable)ex);
        }
        catch (ResourceException ex) {
            throw new TransactionSystemException("Unexpected failure on rollback of CCI local transaction", (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting CCI local transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
        }
        txObject.getConnectionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        CciLocalTransactionObject txObject = (CciLocalTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
        txObject.getConnectionHolder().clear();
        Connection con = txObject.getConnectionHolder().getConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Releasing CCI Connection [" + con + "] after transaction"));
        }
        ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
    }

    private static class CciLocalTransactionObject {
        private ConnectionHolder connectionHolder;

        private CciLocalTransactionObject() {
        }

        public void setConnectionHolder(ConnectionHolder connectionHolder) {
            this.connectionHolder = connectionHolder;
        }

        public ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

