/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class RequestContextHolder {
    public static ThreadLocal requestHolder = new InheritableThreadLocal();

    public static void setRequest(HttpServletRequest request) {
        requestHolder.set(request);
    }

    public static HttpServletRequest getRequest() throws IllegalStateException {
        return (HttpServletRequest)requestHolder.get();
    }

    public static HttpServletRequest currentRequest() throws IllegalStateException {
        HttpServletRequest request = (HttpServletRequest)requestHolder.get();
        if (request == null) {
            throw new IllegalStateException("No thread-bound request: use RequestContextFilter");
        }
        return request;
    }

    public static HttpSession currentSession() throws IllegalStateException {
        return RequestContextHolder.currentRequest().getSession(true);
    }
}

