/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;

public class ControllerAdviceBean
implements Ordered {
    private static final Log logger = LogFactory.getLog(ControllerAdviceBean.class);
    private final Object bean;
    private final int order;
    private final BeanFactory beanFactory;
    private final List<Package> basePackages = new ArrayList<Package>();
    private final List<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
    private final List<Class<?>> assignableTypes = new ArrayList();

    public ControllerAdviceBean(String beanName, BeanFactory beanFactory) {
        Assert.hasText((String)beanName, (String)"Bean name must not be null");
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(beanName)) {
            throw new IllegalArgumentException("BeanFactory [" + beanFactory + "] does not contain bean with name '" + beanName + "'");
        }
        this.bean = beanName;
        this.beanFactory = beanFactory;
        Class beanType = this.beanFactory.getType(beanName);
        this.order = ControllerAdviceBean.initOrderFromBeanType(beanType);
        ControllerAdvice annotation = (ControllerAdvice)AnnotationUtils.findAnnotation((Class)beanType, ControllerAdvice.class);
        Assert.notNull((Object)annotation, (String)("BeanType [" + beanType.getName() + "] is not annotated @ControllerAdvice"));
        this.basePackages.addAll(ControllerAdviceBean.initBasePackagesFromBeanType(beanType, annotation));
        this.annotations.addAll(Arrays.asList(annotation.annotations()));
        this.assignableTypes.addAll(Arrays.asList(annotation.assignableTypes()));
    }

    public ControllerAdviceBean(Object bean) {
        Assert.notNull((Object)bean, (String)"Bean must not be null");
        this.bean = bean;
        this.order = ControllerAdviceBean.initOrderFromBean(bean);
        Class<?> beanType = bean.getClass();
        ControllerAdvice annotation = (ControllerAdvice)AnnotationUtils.findAnnotation(beanType, ControllerAdvice.class);
        Assert.notNull((Object)annotation, (String)("Bean type [" + beanType.getName() + "] is not annotated @ControllerAdvice"));
        this.basePackages.addAll(ControllerAdviceBean.initBasePackagesFromBeanType(beanType, annotation));
        this.annotations.addAll(Arrays.asList(annotation.annotations()));
        this.assignableTypes.addAll(Arrays.asList(annotation.assignableTypes()));
        this.beanFactory = null;
    }

    public int getOrder() {
        return this.order;
    }

    public Class<?> getBeanType() {
        Class clazz = this.bean instanceof String ? this.beanFactory.getType((String)this.bean) : this.bean.getClass();
        return ClassUtils.getUserClass((Class)clazz);
    }

    public Object resolveBean() {
        return this.bean instanceof String ? this.beanFactory.getBean((String)this.bean) : this.bean;
    }

    public boolean isApplicableToBeanType(Class<?> beanType) {
        if (!this.hasSelectors()) {
            return true;
        }
        if (beanType != null) {
            for (Class<?> clazz : this.assignableTypes) {
                if (!ClassUtils.isAssignable(clazz, beanType)) continue;
                return true;
            }
            for (Class<Object> clazz : this.annotations) {
                if (AnnotationUtils.findAnnotation(beanType, clazz) == null) continue;
                return true;
            }
            String packageName = beanType.getPackage().getName();
            for (Package basePackage : this.basePackages) {
                if (!packageName.startsWith(basePackage.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSelectors() {
        return !this.basePackages.isEmpty() || !this.annotations.isEmpty() || !this.assignableTypes.isEmpty();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ControllerAdviceBean && this.bean.equals(((ControllerAdviceBean)other).bean);
    }

    public int hashCode() {
        return this.bean.hashCode();
    }

    public String toString() {
        return this.bean.toString();
    }

    public static List<ControllerAdviceBean> findAnnotatedBeans(ApplicationContext applicationContext) {
        ArrayList<ControllerAdviceBean> beans = new ArrayList<ControllerAdviceBean>();
        for (String name : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)applicationContext, Object.class)) {
            if (applicationContext.findAnnotationOnBean(name, ControllerAdvice.class) == null) continue;
            beans.add(new ControllerAdviceBean(name, (BeanFactory)applicationContext));
        }
        return beans;
    }

    private static int initOrderFromBean(Object bean) {
        return bean instanceof Ordered ? ((Ordered)bean).getOrder() : ControllerAdviceBean.initOrderFromBeanType(bean.getClass());
    }

    private static int initOrderFromBeanType(Class<?> beanType) {
        return OrderUtils.getOrder(beanType, (Integer)Integer.MAX_VALUE);
    }

    private static List<Package> initBasePackagesFromBeanType(Class<?> beanType, ControllerAdvice annotation) {
        ArrayList<Package> basePackages = new ArrayList<Package>();
        ArrayList<String> basePackageNames = new ArrayList<String>();
        basePackageNames.addAll(Arrays.asList(annotation.value()));
        basePackageNames.addAll(Arrays.asList(annotation.basePackages()));
        for (String pkgName : basePackageNames) {
            if (!StringUtils.hasText((String)pkgName)) continue;
            Package pkg = Package.getPackage(pkgName);
            if (pkg != null) {
                basePackages.add(pkg);
                continue;
            }
            logger.warn((Object)("Package [" + pkgName + "] was not found, see [" + beanType.getName() + "]"));
        }
        for (Class<?> markerClass : annotation.basePackageClasses()) {
            Package pack = markerClass.getPackage();
            if (pack != null) {
                basePackages.add(pack);
                continue;
            }
            logger.warn((Object)("Package was not found for class [" + markerClass.getName() + "], see [" + beanType.getName() + "]"));
        }
        return basePackages;
    }
}

