/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.Netty4ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

class Netty4ClientHttpRequest
extends AbstractAsyncClientHttpRequest
implements ClientHttpRequest {
    private final Bootstrap bootstrap;
    private final URI uri;
    private final HttpMethod method;
    private final ByteBufOutputStream body;

    public Netty4ClientHttpRequest(Bootstrap bootstrap, URI uri, HttpMethod method) {
        this.bootstrap = bootstrap;
        this.uri = uri;
        this.method = method;
        this.body = new ByteBufOutputStream(Unpooled.buffer((int)1024));
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        return this.body;
    }

    @Override
    protected ListenableFuture<ClientHttpResponse> executeInternal(final HttpHeaders headers) throws IOException {
        final SettableListenableFuture responseFuture = new SettableListenableFuture();
        ChannelFutureListener connectionListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    Channel channel = future.channel();
                    channel.pipeline().addLast(new ChannelHandler[]{new RequestExecuteHandler((SettableListenableFuture<ClientHttpResponse>)responseFuture)});
                    FullHttpRequest nettyRequest = Netty4ClientHttpRequest.this.createFullHttpRequest(headers);
                    channel.writeAndFlush((Object)nettyRequest);
                } else {
                    responseFuture.setException(future.cause());
                }
            }
        };
        this.bootstrap.connect(this.uri.getHost(), Netty4ClientHttpRequest.getPort(this.uri)).addListener((GenericFutureListener)connectionListener);
        return responseFuture;
    }

    @Override
    public ClientHttpResponse execute() throws IOException {
        try {
            return (ClientHttpResponse)this.executeAsync().get();
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                port = 80;
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                port = 443;
            }
        }
        return port;
    }

    private FullHttpRequest createFullHttpRequest(HttpHeaders headers) {
        io.netty.handler.codec.http.HttpMethod nettyMethod = io.netty.handler.codec.http.HttpMethod.valueOf((String)this.method.name());
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, nettyMethod, this.uri.toString(), this.body.buffer());
        nettyRequest.headers().set("Host", (Object)this.uri.getHost());
        nettyRequest.headers().set("Connection", (Object)"close");
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            nettyRequest.headers().add(entry.getKey(), (Iterable)entry.getValue());
        }
        return nettyRequest;
    }

    private static class RequestExecuteHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private final SettableListenableFuture<ClientHttpResponse> responseFuture;

        public RequestExecuteHandler(SettableListenableFuture<ClientHttpResponse> responseFuture) {
            this.responseFuture = responseFuture;
        }

        protected void channelRead0(ChannelHandlerContext context, FullHttpResponse response) throws Exception {
            this.responseFuture.set((Object)new Netty4ClientHttpResponse(context, response));
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            this.responseFuture.setException(cause);
        }
    }
}

