/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public class GsonDecoder
extends AbstractDataBufferDecoder<Object> {
    private static final MimeType[] DEFAULT_JSON_MIME_TYPES = new MimeType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")};
    private final Gson gson;

    public GsonDecoder() {
        this(new Gson(), DEFAULT_JSON_MIME_TYPES);
    }

    public GsonDecoder(Gson gson, MimeType ... mimeTypes) {
        super(mimeTypes);
        Assert.notNull((Object)gson, (String)"A Gson instance is required");
        this.gson = gson;
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        if (!super.canDecode(elementType, mimeType)) {
            return false;
        }
        return !CharSequence.class.isAssignableFrom(elementType.toClass());
    }

    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        throw new UnsupportedOperationException("Stream decoding is currently not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object decode(DataBuffer buffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        try {
            Object object = this.gson.fromJson((Reader)new InputStreamReader(buffer.asInputStream()), targetType.getType());
            return object;
        }
        finally {
            DataBufferUtils.release((DataBuffer)buffer);
        }
    }
}

